/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.graph;

import hidden.org.apache.maven.execution.ProjectDependencyGraph;
import hidden.org.apache.maven.project.DuplicateProjectException;
import hidden.org.apache.maven.project.MavenProject;
import hidden.org.apache.maven.project.ProjectSorter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.codehaus.plexus.util.dag.CycleDetectedException;

public class DefaultProjectDependencyGraph
implements ProjectDependencyGraph {
    private ProjectSorter sorter;
    private List<MavenProject> allProjects;

    public DefaultProjectDependencyGraph(Collection<MavenProject> projects) throws CycleDetectedException, DuplicateProjectException {
        this.allProjects = Collections.unmodifiableList(new ArrayList<MavenProject>(projects));
        this.sorter = new ProjectSorter(projects);
    }

    public DefaultProjectDependencyGraph(List<MavenProject> allProjects, Collection<MavenProject> projects) throws CycleDetectedException, DuplicateProjectException {
        this.allProjects = Collections.unmodifiableList(new ArrayList<MavenProject>(allProjects));
        this.sorter = new ProjectSorter(projects);
    }

    @Override
    public List<MavenProject> getAllProjects() {
        return this.allProjects;
    }

    @Override
    public List<MavenProject> getSortedProjects() {
        return new ArrayList<MavenProject>(this.sorter.getSortedProjects());
    }

    @Override
    public List<MavenProject> getDownstreamProjects(MavenProject project, boolean transitive) {
        Validate.notNull(project, "project cannot be null", new Object[0]);
        HashSet<String> projectIds = new HashSet<String>();
        this.getDownstreamProjects(ProjectSorter.getId(project), projectIds, transitive);
        return this.getSortedProjects(projectIds);
    }

    private void getDownstreamProjects(String projectId, Set<String> projectIds, boolean transitive) {
        for (String id : this.sorter.getDependents(projectId)) {
            if (!projectIds.add(id) || !transitive) continue;
            this.getDownstreamProjects(id, projectIds, transitive);
        }
    }

    @Override
    public List<MavenProject> getUpstreamProjects(MavenProject project, boolean transitive) {
        Validate.notNull(project, "project cannot be null", new Object[0]);
        HashSet<String> projectIds = new HashSet<String>();
        this.getUpstreamProjects(ProjectSorter.getId(project), projectIds, transitive);
        return this.getSortedProjects(projectIds);
    }

    private void getUpstreamProjects(String projectId, Collection<String> projectIds, boolean transitive) {
        for (String id : this.sorter.getDependencies(projectId)) {
            if (!projectIds.add(id) || !transitive) continue;
            this.getUpstreamProjects(id, projectIds, transitive);
        }
    }

    private List<MavenProject> getSortedProjects(Set<String> projectIds) {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>(projectIds.size());
        for (MavenProject mavenProject : this.sorter.getSortedProjects()) {
            if (!projectIds.contains(ProjectSorter.getId(mavenProject))) continue;
            result.add(mavenProject);
        }
        return result;
    }

    public String toString() {
        return this.sorter.getSortedProjects().toString();
    }
}

