/*
 * Decompiled with CFR 0.152.
 */
package hidden.com.google.inject.internal;

import hidden.com.google.common.base.MoreObjects;
import hidden.com.google.common.base.Preconditions;
import hidden.com.google.common.collect.ImmutableList;
import hidden.com.google.common.collect.ImmutableMap;
import hidden.com.google.common.collect.Lists;
import hidden.com.google.common.collect.Maps;
import hidden.com.google.inject.Binder;
import hidden.com.google.inject.Injector;
import hidden.com.google.inject.Key;
import hidden.com.google.inject.PrivateBinder;
import hidden.com.google.inject.internal.ExposureBuilder;
import hidden.com.google.inject.spi.Element;
import hidden.com.google.inject.spi.ElementVisitor;
import hidden.com.google.inject.spi.PrivateElements;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class PrivateElementsImpl
implements PrivateElements {
    private final Object source;
    private List<Element> elementsMutable = Lists.newArrayList();
    private List<ExposureBuilder<?>> exposureBuilders = Lists.newArrayList();
    private ImmutableList<Element> elements;
    private ImmutableMap<Key<?>, Object> exposedKeysToSources;
    private Injector injector;

    public PrivateElementsImpl(Object source) {
        this.source = Preconditions.checkNotNull(source, "source");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public List<Element> getElements() {
        if (this.elements == null) {
            this.elements = ImmutableList.copyOf(this.elementsMutable);
            this.elementsMutable = null;
        }
        return this.elements;
    }

    @Override
    public Injector getInjector() {
        return this.injector;
    }

    public void initInjector(Injector injector) {
        Preconditions.checkState(this.injector == null, "injector already initialized");
        this.injector = Preconditions.checkNotNull(injector, "injector");
    }

    @Override
    public Set<Key<?>> getExposedKeys() {
        if (this.exposedKeysToSources == null) {
            LinkedHashMap<Key<?>, Object> exposedKeysToSourcesMutable = Maps.newLinkedHashMap();
            for (ExposureBuilder<?> exposureBuilder : this.exposureBuilders) {
                exposedKeysToSourcesMutable.put(exposureBuilder.getKey(), exposureBuilder.getSource());
            }
            this.exposedKeysToSources = ImmutableMap.copyOf(exposedKeysToSourcesMutable);
            this.exposureBuilders = null;
        }
        return this.exposedKeysToSources.keySet();
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public List<Element> getElementsMutable() {
        return this.elementsMutable;
    }

    public void addExposureBuilder(ExposureBuilder<?> exposureBuilder) {
        this.exposureBuilders.add(exposureBuilder);
    }

    @Override
    public void applyTo(Binder binder) {
        PrivateBinder privateBinder = binder.withSource(this.source).newPrivateBinder();
        for (Element element : this.getElements()) {
            element.applyTo(privateBinder);
        }
        this.getExposedKeys();
        for (Map.Entry entry : this.exposedKeysToSources.entrySet()) {
            privateBinder.withSource(entry.getValue()).expose((Key)entry.getKey());
        }
    }

    @Override
    public Object getExposedSource(Key<?> key) {
        this.getExposedKeys();
        Object source = this.exposedKeysToSources.get(key);
        Preconditions.checkArgument(source != null, "%s not exposed by %s.", key, (Object)this);
        return source;
    }

    public String toString() {
        return MoreObjects.toStringHelper(PrivateElements.class).add("exposedKeys", this.getExposedKeys()).add("source", this.getSource()).toString();
    }
}

