/*
 * Decompiled with CFR 0.152.
 */
package hidden.com.google.inject.internal;

import hidden.com.google.common.base.MoreObjects;
import hidden.com.google.inject.Key;
import hidden.com.google.inject.internal.CreationListener;
import hidden.com.google.inject.internal.Errors;
import hidden.com.google.inject.internal.ErrorsException;
import hidden.com.google.inject.internal.InjectorImpl;
import hidden.com.google.inject.internal.InternalContext;
import hidden.com.google.inject.internal.InternalFactory;
import hidden.com.google.inject.internal.InternalProvisionException;
import hidden.com.google.inject.spi.Dependency;

final class FactoryProxy<T>
implements InternalFactory<T>,
CreationListener {
    private final InjectorImpl injector;
    private final Key<T> key;
    private final Key<? extends T> targetKey;
    private final Object source;
    private InternalFactory<? extends T> targetFactory;

    FactoryProxy(InjectorImpl injector, Key<T> key, Key<? extends T> targetKey, Object source) {
        this.injector = injector;
        this.key = key;
        this.targetKey = targetKey;
        this.source = source;
    }

    @Override
    public void notify(Errors errors) {
        try {
            this.targetFactory = this.injector.getInternalFactory(this.targetKey, errors.withSource(this.source), InjectorImpl.JitLimitation.NEW_OR_EXISTING_JIT);
        }
        catch (ErrorsException e) {
            errors.merge(e.getErrors());
        }
    }

    @Override
    public T get(InternalContext context, Dependency<?> dependency, boolean linked) throws InternalProvisionException {
        Key<? extends T> localTargetKey = this.targetKey;
        context.pushState(localTargetKey, this.source);
        try {
            T t = this.targetFactory.get(context, dependency, true);
            return t;
        }
        catch (InternalProvisionException ipe) {
            throw ipe.addSource(localTargetKey);
        }
        finally {
            context.popState();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(FactoryProxy.class).add("key", this.key).add("provider", this.targetFactory).toString();
    }
}

