/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.eclipse.aether.internal.impl;

import hidden.org.eclipse.aether.RepositorySystem;
import hidden.org.eclipse.aether.RepositorySystemSession;
import hidden.org.eclipse.aether.RequestTrace;
import hidden.org.eclipse.aether.SyncContext;
import hidden.org.eclipse.aether.artifact.Artifact;
import hidden.org.eclipse.aether.collection.CollectRequest;
import hidden.org.eclipse.aether.collection.CollectResult;
import hidden.org.eclipse.aether.collection.DependencyCollectionException;
import hidden.org.eclipse.aether.deployment.DeployRequest;
import hidden.org.eclipse.aether.deployment.DeployResult;
import hidden.org.eclipse.aether.deployment.DeploymentException;
import hidden.org.eclipse.aether.graph.DependencyFilter;
import hidden.org.eclipse.aether.graph.DependencyVisitor;
import hidden.org.eclipse.aether.impl.ArtifactDescriptorReader;
import hidden.org.eclipse.aether.impl.ArtifactResolver;
import hidden.org.eclipse.aether.impl.DependencyCollector;
import hidden.org.eclipse.aether.impl.Deployer;
import hidden.org.eclipse.aether.impl.Installer;
import hidden.org.eclipse.aether.impl.LocalRepositoryProvider;
import hidden.org.eclipse.aether.impl.MetadataResolver;
import hidden.org.eclipse.aether.impl.RemoteRepositoryManager;
import hidden.org.eclipse.aether.impl.SyncContextFactory;
import hidden.org.eclipse.aether.impl.VersionRangeResolver;
import hidden.org.eclipse.aether.impl.VersionResolver;
import hidden.org.eclipse.aether.installation.InstallRequest;
import hidden.org.eclipse.aether.installation.InstallResult;
import hidden.org.eclipse.aether.installation.InstallationException;
import hidden.org.eclipse.aether.internal.impl.ArtifactRequestBuilder;
import hidden.org.eclipse.aether.repository.Authentication;
import hidden.org.eclipse.aether.repository.LocalRepository;
import hidden.org.eclipse.aether.repository.LocalRepositoryManager;
import hidden.org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import hidden.org.eclipse.aether.repository.Proxy;
import hidden.org.eclipse.aether.repository.RemoteRepository;
import hidden.org.eclipse.aether.resolution.ArtifactDescriptorException;
import hidden.org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import hidden.org.eclipse.aether.resolution.ArtifactDescriptorResult;
import hidden.org.eclipse.aether.resolution.ArtifactRequest;
import hidden.org.eclipse.aether.resolution.ArtifactResolutionException;
import hidden.org.eclipse.aether.resolution.ArtifactResult;
import hidden.org.eclipse.aether.resolution.DependencyRequest;
import hidden.org.eclipse.aether.resolution.DependencyResolutionException;
import hidden.org.eclipse.aether.resolution.DependencyResult;
import hidden.org.eclipse.aether.resolution.MetadataRequest;
import hidden.org.eclipse.aether.resolution.MetadataResult;
import hidden.org.eclipse.aether.resolution.VersionRangeRequest;
import hidden.org.eclipse.aether.resolution.VersionRangeResolutionException;
import hidden.org.eclipse.aether.resolution.VersionRangeResult;
import hidden.org.eclipse.aether.resolution.VersionRequest;
import hidden.org.eclipse.aether.resolution.VersionResolutionException;
import hidden.org.eclipse.aether.resolution.VersionResult;
import hidden.org.eclipse.aether.spi.locator.Service;
import hidden.org.eclipse.aether.spi.locator.ServiceLocator;
import hidden.org.eclipse.aether.spi.log.Logger;
import hidden.org.eclipse.aether.spi.log.LoggerFactory;
import hidden.org.eclipse.aether.spi.log.NullLoggerFactory;
import hidden.org.eclipse.aether.util.graph.visitor.FilteringDependencyVisitor;
import hidden.org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class DefaultRepositorySystem
implements RepositorySystem,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private VersionResolver versionResolver;
    private VersionRangeResolver versionRangeResolver;
    private ArtifactResolver artifactResolver;
    private MetadataResolver metadataResolver;
    private ArtifactDescriptorReader artifactDescriptorReader;
    private DependencyCollector dependencyCollector;
    private Installer installer;
    private Deployer deployer;
    private LocalRepositoryProvider localRepositoryProvider;
    private SyncContextFactory syncContextFactory;
    private RemoteRepositoryManager remoteRepositoryManager;

    public DefaultRepositorySystem() {
    }

    @Inject
    DefaultRepositorySystem(VersionResolver versionResolver, VersionRangeResolver versionRangeResolver, ArtifactResolver artifactResolver, MetadataResolver metadataResolver, ArtifactDescriptorReader artifactDescriptorReader, DependencyCollector dependencyCollector, Installer installer, Deployer deployer, LocalRepositoryProvider localRepositoryProvider, SyncContextFactory syncContextFactory, RemoteRepositoryManager remoteRepositoryManager, LoggerFactory loggerFactory) {
        this.setVersionResolver(versionResolver);
        this.setVersionRangeResolver(versionRangeResolver);
        this.setArtifactResolver(artifactResolver);
        this.setMetadataResolver(metadataResolver);
        this.setArtifactDescriptorReader(artifactDescriptorReader);
        this.setDependencyCollector(dependencyCollector);
        this.setInstaller(installer);
        this.setDeployer(deployer);
        this.setLocalRepositoryProvider(localRepositoryProvider);
        this.setSyncContextFactory(syncContextFactory);
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setLoggerFactory(loggerFactory);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
        this.setVersionResolver(locator.getService(VersionResolver.class));
        this.setVersionRangeResolver(locator.getService(VersionRangeResolver.class));
        this.setArtifactResolver(locator.getService(ArtifactResolver.class));
        this.setMetadataResolver(locator.getService(MetadataResolver.class));
        this.setArtifactDescriptorReader(locator.getService(ArtifactDescriptorReader.class));
        this.setDependencyCollector(locator.getService(DependencyCollector.class));
        this.setInstaller(locator.getService(Installer.class));
        this.setDeployer(locator.getService(Deployer.class));
        this.setLocalRepositoryProvider(locator.getService(LocalRepositoryProvider.class));
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
    }

    public DefaultRepositorySystem setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    public DefaultRepositorySystem setVersionResolver(VersionResolver versionResolver) {
        if (versionResolver == null) {
            throw new IllegalArgumentException("version resolver has not been specified");
        }
        this.versionResolver = versionResolver;
        return this;
    }

    public DefaultRepositorySystem setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        if (versionRangeResolver == null) {
            throw new IllegalArgumentException("version range resolver has not been specified");
        }
        this.versionRangeResolver = versionRangeResolver;
        return this;
    }

    public DefaultRepositorySystem setArtifactResolver(ArtifactResolver artifactResolver) {
        if (artifactResolver == null) {
            throw new IllegalArgumentException("artifact resolver has not been specified");
        }
        this.artifactResolver = artifactResolver;
        return this;
    }

    public DefaultRepositorySystem setMetadataResolver(MetadataResolver metadataResolver) {
        if (metadataResolver == null) {
            throw new IllegalArgumentException("metadata resolver has not been specified");
        }
        this.metadataResolver = metadataResolver;
        return this;
    }

    public DefaultRepositorySystem setArtifactDescriptorReader(ArtifactDescriptorReader artifactDescriptorReader) {
        if (artifactDescriptorReader == null) {
            throw new IllegalArgumentException("artifact descriptor reader has not been specified");
        }
        this.artifactDescriptorReader = artifactDescriptorReader;
        return this;
    }

    public DefaultRepositorySystem setDependencyCollector(DependencyCollector dependencyCollector) {
        if (dependencyCollector == null) {
            throw new IllegalArgumentException("dependency collector has not been specified");
        }
        this.dependencyCollector = dependencyCollector;
        return this;
    }

    public DefaultRepositorySystem setInstaller(Installer installer) {
        if (installer == null) {
            throw new IllegalArgumentException("installer has not been specified");
        }
        this.installer = installer;
        return this;
    }

    public DefaultRepositorySystem setDeployer(Deployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("deployer has not been specified");
        }
        this.deployer = deployer;
        return this;
    }

    public DefaultRepositorySystem setLocalRepositoryProvider(LocalRepositoryProvider localRepositoryProvider) {
        if (localRepositoryProvider == null) {
            throw new IllegalArgumentException("local repository provider has not been specified");
        }
        this.localRepositoryProvider = localRepositoryProvider;
        return this;
    }

    public DefaultRepositorySystem setSyncContextFactory(SyncContextFactory syncContextFactory) {
        if (syncContextFactory == null) {
            throw new IllegalArgumentException("sync context factory has not been specified");
        }
        this.syncContextFactory = syncContextFactory;
        return this;
    }

    public DefaultRepositorySystem setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        if (remoteRepositoryManager == null) {
            throw new IllegalArgumentException("remote repository manager has not been specified");
        }
        this.remoteRepositoryManager = remoteRepositoryManager;
        return this;
    }

    @Override
    public VersionResult resolveVersion(RepositorySystemSession session, VersionRequest request) throws VersionResolutionException {
        this.validateSession(session);
        return this.versionResolver.resolveVersion(session, request);
    }

    @Override
    public VersionRangeResult resolveVersionRange(RepositorySystemSession session, VersionRangeRequest request) throws VersionRangeResolutionException {
        this.validateSession(session);
        return this.versionRangeResolver.resolveVersionRange(session, request);
    }

    @Override
    public ArtifactDescriptorResult readArtifactDescriptor(RepositorySystemSession session, ArtifactDescriptorRequest request) throws ArtifactDescriptorException {
        this.validateSession(session);
        return this.artifactDescriptorReader.readArtifactDescriptor(session, request);
    }

    @Override
    public ArtifactResult resolveArtifact(RepositorySystemSession session, ArtifactRequest request) throws ArtifactResolutionException {
        this.validateSession(session);
        return this.artifactResolver.resolveArtifact(session, request);
    }

    @Override
    public List<ArtifactResult> resolveArtifacts(RepositorySystemSession session, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        this.validateSession(session);
        return this.artifactResolver.resolveArtifacts(session, requests);
    }

    @Override
    public List<MetadataResult> resolveMetadata(RepositorySystemSession session, Collection<? extends MetadataRequest> requests) {
        this.validateSession(session);
        return this.metadataResolver.resolveMetadata(session, requests);
    }

    @Override
    public CollectResult collectDependencies(RepositorySystemSession session, CollectRequest request) throws DependencyCollectionException {
        this.validateSession(session);
        return this.dependencyCollector.collectDependencies(session, request);
    }

    @Override
    public DependencyResult resolveDependencies(RepositorySystemSession session, DependencyRequest request) throws DependencyResolutionException {
        List<ArtifactResult> results;
        this.validateSession(session);
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        DependencyResult result = new DependencyResult(request);
        DependencyCollectionException dce = null;
        ArtifactResolutionException are = null;
        if (request.getRoot() != null) {
            result.setRoot(request.getRoot());
        } else if (request.getCollectRequest() != null) {
            CollectResult collectResult;
            try {
                request.getCollectRequest().setTrace(trace);
                collectResult = this.dependencyCollector.collectDependencies(session, request.getCollectRequest());
            }
            catch (DependencyCollectionException e) {
                dce = e;
                collectResult = e.getResult();
            }
            result.setRoot(collectResult.getRoot());
            result.setCycles(collectResult.getCycles());
            result.setCollectExceptions(collectResult.getExceptions());
        } else {
            throw new IllegalArgumentException("dependency node or collect request missing");
        }
        ArtifactRequestBuilder builder = new ArtifactRequestBuilder(trace);
        DependencyFilter filter = request.getFilter();
        DependencyVisitor visitor = filter != null ? new FilteringDependencyVisitor(builder, filter) : builder;
        visitor = new TreeDependencyVisitor(visitor);
        result.getRoot().accept(visitor);
        List<ArtifactRequest> requests = builder.getRequests();
        try {
            results = this.artifactResolver.resolveArtifacts(session, requests);
        }
        catch (ArtifactResolutionException e) {
            are = e;
            results = e.getResults();
        }
        result.setArtifactResults(results);
        this.updateNodesWithResolvedArtifacts(results);
        if (dce != null) {
            throw new DependencyResolutionException(result, (Throwable)dce);
        }
        if (are != null) {
            throw new DependencyResolutionException(result, (Throwable)are);
        }
        return result;
    }

    private void updateNodesWithResolvedArtifacts(List<ArtifactResult> results) {
        for (ArtifactResult result : results) {
            Artifact artifact = result.getArtifact();
            if (artifact == null) continue;
            result.getRequest().getDependencyNode().setArtifact(artifact);
        }
    }

    @Override
    public InstallResult install(RepositorySystemSession session, InstallRequest request) throws InstallationException {
        this.validateSession(session);
        return this.installer.install(session, request);
    }

    @Override
    public DeployResult deploy(RepositorySystemSession session, DeployRequest request) throws DeploymentException {
        this.validateSession(session);
        return this.deployer.deploy(session, request);
    }

    @Override
    public LocalRepositoryManager newLocalRepositoryManager(RepositorySystemSession session, LocalRepository localRepository) {
        try {
            return this.localRepositoryProvider.newLocalRepositoryManager(session, localRepository);
        }
        catch (NoLocalRepositoryManagerException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public SyncContext newSyncContext(RepositorySystemSession session, boolean shared) {
        this.validateSession(session);
        return this.syncContextFactory.newInstance(session, shared);
    }

    @Override
    public List<RemoteRepository> newResolutionRepositories(RepositorySystemSession session, List<RemoteRepository> repositories) {
        this.validateSession(session);
        repositories = this.remoteRepositoryManager.aggregateRepositories(session, new ArrayList<RemoteRepository>(), repositories, true);
        return repositories;
    }

    @Override
    public RemoteRepository newDeploymentRepository(RepositorySystemSession session, RemoteRepository repository) {
        this.validateSession(session);
        RemoteRepository.Builder builder = new RemoteRepository.Builder(repository);
        Authentication auth = session.getAuthenticationSelector().getAuthentication(repository);
        builder.setAuthentication(auth);
        Proxy proxy = session.getProxySelector().getProxy(repository);
        builder.setProxy(proxy);
        return builder.build();
    }

    private void validateSession(RepositorySystemSession session) {
        if (session == null) {
            throw new IllegalArgumentException("Invalid repository system session: the session may not be null.");
        }
        if (session.getLocalRepositoryManager() == null) {
            this.invalidSession("LocalRepositoryManager");
        }
        if (session.getSystemProperties() == null) {
            this.invalidSession("SystemProperties");
        }
        if (session.getUserProperties() == null) {
            this.invalidSession("UserProperties");
        }
        if (session.getConfigProperties() == null) {
            this.invalidSession("ConfigProperties");
        }
        if (session.getMirrorSelector() == null) {
            this.invalidSession("MirrorSelector");
        }
        if (session.getProxySelector() == null) {
            this.invalidSession("ProxySelector");
        }
        if (session.getAuthenticationSelector() == null) {
            this.invalidSession("AuthenticationSelector");
        }
        if (session.getArtifactTypeRegistry() == null) {
            this.invalidSession("ArtifactTypeRegistry");
        }
        if (session.getData() == null) {
            this.invalidSession("Data");
        }
    }

    private void invalidSession(String name) {
        throw new IllegalArgumentException("Invalid repository system session: " + name + " is not set.");
    }
}

