/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.eclipse.aether.impl;

import hidden.org.eclipse.aether.RepositorySystem;
import hidden.org.eclipse.aether.impl.ArtifactResolver;
import hidden.org.eclipse.aether.impl.DependencyCollector;
import hidden.org.eclipse.aether.impl.Deployer;
import hidden.org.eclipse.aether.impl.Installer;
import hidden.org.eclipse.aether.impl.LocalRepositoryProvider;
import hidden.org.eclipse.aether.impl.MetadataResolver;
import hidden.org.eclipse.aether.impl.OfflineController;
import hidden.org.eclipse.aether.impl.RemoteRepositoryManager;
import hidden.org.eclipse.aether.impl.RepositoryConnectorProvider;
import hidden.org.eclipse.aether.impl.RepositoryEventDispatcher;
import hidden.org.eclipse.aether.impl.SyncContextFactory;
import hidden.org.eclipse.aether.impl.UpdateCheckManager;
import hidden.org.eclipse.aether.impl.UpdatePolicyAnalyzer;
import hidden.org.eclipse.aether.internal.impl.DefaultArtifactResolver;
import hidden.org.eclipse.aether.internal.impl.DefaultChecksumPolicyProvider;
import hidden.org.eclipse.aether.internal.impl.DefaultDependencyCollector;
import hidden.org.eclipse.aether.internal.impl.DefaultDeployer;
import hidden.org.eclipse.aether.internal.impl.DefaultFileProcessor;
import hidden.org.eclipse.aether.internal.impl.DefaultInstaller;
import hidden.org.eclipse.aether.internal.impl.DefaultLocalRepositoryProvider;
import hidden.org.eclipse.aether.internal.impl.DefaultMetadataResolver;
import hidden.org.eclipse.aether.internal.impl.DefaultOfflineController;
import hidden.org.eclipse.aether.internal.impl.DefaultRemoteRepositoryManager;
import hidden.org.eclipse.aether.internal.impl.DefaultRepositoryConnectorProvider;
import hidden.org.eclipse.aether.internal.impl.DefaultRepositoryEventDispatcher;
import hidden.org.eclipse.aether.internal.impl.DefaultRepositoryLayoutProvider;
import hidden.org.eclipse.aether.internal.impl.DefaultRepositorySystem;
import hidden.org.eclipse.aether.internal.impl.DefaultSyncContextFactory;
import hidden.org.eclipse.aether.internal.impl.DefaultTransporterProvider;
import hidden.org.eclipse.aether.internal.impl.DefaultUpdateCheckManager;
import hidden.org.eclipse.aether.internal.impl.DefaultUpdatePolicyAnalyzer;
import hidden.org.eclipse.aether.internal.impl.EnhancedLocalRepositoryManagerFactory;
import hidden.org.eclipse.aether.internal.impl.Maven2RepositoryLayoutFactory;
import hidden.org.eclipse.aether.internal.impl.SimpleLocalRepositoryManagerFactory;
import hidden.org.eclipse.aether.internal.impl.slf4j.Slf4jLoggerFactory;
import hidden.org.eclipse.aether.spi.connector.checksum.ChecksumPolicyProvider;
import hidden.org.eclipse.aether.spi.connector.layout.RepositoryLayoutFactory;
import hidden.org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import hidden.org.eclipse.aether.spi.connector.transport.TransporterProvider;
import hidden.org.eclipse.aether.spi.io.FileProcessor;
import hidden.org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import hidden.org.eclipse.aether.spi.locator.Service;
import hidden.org.eclipse.aether.spi.locator.ServiceLocator;
import hidden.org.eclipse.aether.spi.log.LoggerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public final class DefaultServiceLocator
implements ServiceLocator {
    private final Map<Class<?>, Entry<?>> entries = new HashMap();
    private ErrorHandler errorHandler;

    public DefaultServiceLocator() {
        this.addService(RepositorySystem.class, DefaultRepositorySystem.class);
        this.addService(ArtifactResolver.class, DefaultArtifactResolver.class);
        this.addService(DependencyCollector.class, DefaultDependencyCollector.class);
        this.addService(Deployer.class, DefaultDeployer.class);
        this.addService(Installer.class, DefaultInstaller.class);
        this.addService(MetadataResolver.class, DefaultMetadataResolver.class);
        this.addService(RepositoryLayoutProvider.class, DefaultRepositoryLayoutProvider.class);
        this.addService(RepositoryLayoutFactory.class, Maven2RepositoryLayoutFactory.class);
        this.addService(TransporterProvider.class, DefaultTransporterProvider.class);
        this.addService(ChecksumPolicyProvider.class, DefaultChecksumPolicyProvider.class);
        this.addService(RepositoryConnectorProvider.class, DefaultRepositoryConnectorProvider.class);
        this.addService(RemoteRepositoryManager.class, DefaultRemoteRepositoryManager.class);
        this.addService(UpdateCheckManager.class, DefaultUpdateCheckManager.class);
        this.addService(UpdatePolicyAnalyzer.class, DefaultUpdatePolicyAnalyzer.class);
        this.addService(FileProcessor.class, DefaultFileProcessor.class);
        this.addService(SyncContextFactory.class, DefaultSyncContextFactory.class);
        this.addService(RepositoryEventDispatcher.class, DefaultRepositoryEventDispatcher.class);
        this.addService(OfflineController.class, DefaultOfflineController.class);
        this.addService(LocalRepositoryProvider.class, DefaultLocalRepositoryProvider.class);
        this.addService(LocalRepositoryManagerFactory.class, SimpleLocalRepositoryManagerFactory.class);
        this.addService(LocalRepositoryManagerFactory.class, EnhancedLocalRepositoryManagerFactory.class);
        if (Slf4jLoggerFactory.isSlf4jAvailable()) {
            this.addService(LoggerFactory.class, Slf4jLoggerFactory.class);
        }
    }

    private <T> Entry<T> getEntry(Class<T> type, boolean create) {
        if (type == null) {
            throw new IllegalArgumentException("service type not specified");
        }
        Entry<Object> entry = this.entries.get(type);
        if (entry == null && create) {
            entry = new Entry<T>(type);
            this.entries.put(type, entry);
        }
        return entry;
    }

    public <T> DefaultServiceLocator setService(Class<T> type, Class<? extends T> impl) {
        this.getEntry(type, true).setService(impl);
        return this;
    }

    public <T> DefaultServiceLocator addService(Class<T> type, Class<? extends T> impl) {
        this.getEntry(type, true).addService(impl);
        return this;
    }

    public <T> DefaultServiceLocator setServices(Class<T> type, T ... services) {
        this.getEntry(type, true).setServices(services);
        return this;
    }

    @Override
    public <T> T getService(Class<T> type) {
        Entry<T> entry = this.getEntry(type, false);
        return entry != null ? (T)entry.getInstance() : null;
    }

    @Override
    public <T> List<T> getServices(Class<T> type) {
        Entry<T> entry = this.getEntry(type, false);
        return entry != null ? entry.getInstances() : null;
    }

    private void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
        if (this.errorHandler != null) {
            this.errorHandler.serviceCreationFailed(type, impl, exception);
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public static abstract class ErrorHandler {
        public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
        }
    }

    private class Entry<T> {
        private final Class<T> type;
        private final Collection<Object> providers;
        private List<T> instances;

        public Entry(Class<T> type) {
            if (type == null) {
                throw new IllegalArgumentException("service type not specified");
            }
            this.type = type;
            this.providers = new LinkedHashSet<Object>(8);
        }

        public synchronized void setServices(T ... services) {
            this.providers.clear();
            if (services != null) {
                for (T service : services) {
                    if (service == null) {
                        throw new IllegalArgumentException("service instance not specified");
                    }
                    this.providers.add(service);
                }
            }
            this.instances = null;
        }

        public synchronized void setService(Class<? extends T> impl) {
            this.providers.clear();
            this.addService(impl);
        }

        public synchronized void addService(Class<? extends T> impl) {
            if (impl == null) {
                throw new IllegalArgumentException("implementation class not specified");
            }
            this.providers.add(impl);
            this.instances = null;
        }

        public T getInstance() {
            List<T> instances = this.getInstances();
            return instances.isEmpty() ? null : (T)instances.get(0);
        }

        public synchronized List<T> getInstances() {
            if (this.instances == null) {
                this.instances = new ArrayList<T>(this.providers.size());
                for (Object provider : this.providers) {
                    T instance = provider instanceof Class ? this.newInstance((Class)provider) : this.type.cast(provider);
                    if (instance == null) continue;
                    this.instances.add(instance);
                }
                this.instances = Collections.unmodifiableList(this.instances);
            }
            return this.instances;
        }

        private T newInstance(Class<?> impl) {
            try {
                Object obj;
                T instance;
                Constructor<?> constr = impl.getDeclaredConstructor(new Class[0]);
                if (!Modifier.isPublic(constr.getModifiers())) {
                    constr.setAccessible(true);
                }
                if ((instance = this.type.cast(obj = constr.newInstance(new Object[0]))) instanceof Service) {
                    ((Service)instance).initService(DefaultServiceLocator.this);
                }
                return instance;
            }
            catch (Exception e) {
                DefaultServiceLocator.this.serviceCreationFailed(this.type, impl, e);
            }
            catch (LinkageError e) {
                DefaultServiceLocator.this.serviceCreationFailed(this.type, impl, e);
            }
            return null;
        }
    }
}

