/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.experimental.gradle;

import groovy.util.Node;
import io.spring.gradle.dependencymanagement.dsl.DependencyManagementExtension;
import io.spring.gradle.dependencymanagement.maven.PomDependencyManagementConfigurer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.XmlProvider;
import org.gradle.api.artifacts.maven.MavenPom;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.plugins.MavenPluginConvention;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskExecutionException;

public class PomTask
extends DefaultTask {
    @OutputFile
    private File output;

    @TaskAction
    public void generate() {
        try {
            this.getLogger().info("Output: " + this.output);
            DependencyManagementExtension dependencies = (DependencyManagementExtension)this.getProject().getExtensions().findByType(DependencyManagementExtension.class);
            if (dependencies != null) {
                PomDependencyManagementConfigurer pomConfigurer = dependencies.getPomConfigurer();
                MavenPluginConvention maven = (MavenPluginConvention)this.getProject().getConvention().findPlugin(MavenPluginConvention.class);
                if (maven != null) {
                    this.getLogger().info("Generating pom.xml with maven plugin");
                    this.output.mkdirs();
                    MavenPom pom = maven.pom();
                    pom.withXml((Action)new RepositoryAdder(this.getProject()));
                    pom.withXml((Action)pomConfigurer).writeTo((Object)new File(this.output, "pom.xml"));
                } else {
                    TaskCollection tasks = this.getProject().getTasks().withType(GenerateMavenPom.class);
                    if (!tasks.isEmpty()) {
                        this.getLogger().info("Generating pom.xml with maven-publish plugin");
                        this.output.mkdirs();
                        GenerateMavenPom plugin = (GenerateMavenPom)tasks.iterator().next();
                        plugin.setDestination((Object)new File(this.output, "pom.xml"));
                        plugin.getPom().withXml((Action)new RepositoryAdder(this.getProject()));
                        plugin.doGenerate();
                    } else {
                        this.getLogger().warn("Skipping pom generation (maybe you forgot to apply plugin: 'maven' or 'maven-publish'?)");
                    }
                }
            } else {
                this.getLogger().warn("Skipping pom generation (maybe you forgot to apply plugin: 'io.spring.dependency-management'?)");
            }
        }
        catch (Exception e) {
            throw new TaskExecutionException((Task)this, (Throwable)e);
        }
    }

    public void setOutput(File output) {
        this.output = output;
    }

    private final class RepositoryAdder
    implements Action<XmlProvider> {
        private static final String NODE_NAME_REPOSITORIES = "repositories";
        private static final String NODE_NAME_REPOSITORY = "repository";
        private static final String NODE_NAME_ID = "id";
        private static final String NODE_NAME_URL = "url";
        private Project project;

        public RepositoryAdder(Project project) {
            this.project = project;
        }

        public void execute(XmlProvider xml) {
            ArrayList<MavenArtifactRepository> repos = new ArrayList<MavenArtifactRepository>();
            for (ArtifactRepository repo : this.project.getRepositories()) {
                if (!(repo instanceof MavenArtifactRepository)) continue;
                MavenArtifactRepository maven = (MavenArtifactRepository)repo;
                String proto = "" + maven.getUrl().getScheme();
                String host = maven.getUrl().getHost();
                if (!proto.startsWith("http") || host.contains("repo.maven.apache.org")) continue;
                repos.add(maven);
            }
            if (repos.isEmpty()) {
                return;
            }
            this.configurePom(xml.asNode(), repos);
        }

        private void configurePom(Node pom, List<MavenArtifactRepository> repos) {
            Node repositoriesNode = this.findChild(pom, NODE_NAME_REPOSITORIES);
            if (repositoriesNode == null) {
                repositoriesNode = pom.appendNode((Object)NODE_NAME_REPOSITORIES);
            }
            this.configureRepositories(repositoriesNode, repos);
        }

        private void configureRepositories(Node repositoriesNode, List<MavenArtifactRepository> repos) {
            for (MavenArtifactRepository repo : repos) {
                Node node = repositoriesNode.appendNode((Object)NODE_NAME_REPOSITORY);
                node.appendNode((Object)NODE_NAME_ID, (Object)repo.getName());
                node.appendNode((Object)NODE_NAME_URL, (Object)repo.getUrl().toString());
            }
        }

        private Node findChild(Node node, String name) {
            for (Object childObject : node.children()) {
                if (!(childObject instanceof Node) || !((Node)childObject).name().equals(name)) continue;
                return (Node)childObject;
            }
            return null;
        }
    }
}

