/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.batch.core.job.JobExecution;
import org.springframework.batch.core.job.JobInstance;
import org.springframework.batch.core.job.parameters.JobParameters;
import org.springframework.batch.core.step.StepExecution;
import org.springframework.batch.infrastructure.item.ExecutionContext;

public class MetaDataInstanceFactory {
    public static final String DEFAULT_JOB_NAME = "job";
    public static final long DEFAULT_JOB_INSTANCE_ID = 12L;
    public static final long DEFAULT_JOB_EXECUTION_ID = 123L;
    public static final String DEFAULT_STEP_NAME = "step";
    public static final long DEFAULT_STEP_EXECUTION_ID = 1234L;
    private static final AtomicLong jobExecutionIdCounter = new AtomicLong(123L);
    private static final AtomicLong stepExecutionIdCounter = new AtomicLong(1234L);

    public static JobInstance createJobInstance(String jobName, Long instanceId) {
        return new JobInstance(instanceId.longValue(), jobName);
    }

    public static JobInstance createJobInstance() {
        return new JobInstance(12L, DEFAULT_JOB_NAME);
    }

    public static JobExecution createJobExecution() {
        return MetaDataInstanceFactory.createJobExecution(123L);
    }

    public static JobExecution createJobExecution(Long executionId) {
        return MetaDataInstanceFactory.createJobExecution(DEFAULT_JOB_NAME, 12L, executionId);
    }

    public static JobExecution createJobExecution(String jobName, Long instanceId, Long executionId) {
        return MetaDataInstanceFactory.createJobExecution(jobName, instanceId, executionId, new JobParameters());
    }

    public static JobExecution createJobExecution(String jobName, Long instanceId, Long executionId, JobParameters jobParameters) {
        return new JobExecution(executionId.longValue(), MetaDataInstanceFactory.createJobInstance(jobName, instanceId), jobParameters);
    }

    public static StepExecution createStepExecution() {
        return MetaDataInstanceFactory.createStepExecution(DEFAULT_STEP_NAME, 1234L);
    }

    public static StepExecution createStepExecution(String stepName, Long executionId) {
        return MetaDataInstanceFactory.createStepExecution(MetaDataInstanceFactory.createJobExecution(), stepName, executionId);
    }

    public static StepExecution createStepExecution(JobExecution jobExecution, String stepName, Long executionId) {
        return new StepExecution(executionId.longValue(), stepName, jobExecution);
    }

    public static JobExecution createJobExecutionWithStepExecutions(Long executionId, Collection<String> stepNames) {
        JobExecution jobExecution = MetaDataInstanceFactory.createJobExecution(DEFAULT_JOB_NAME, 12L, executionId);
        Long stepExecutionId = 1234L;
        for (String stepName : stepNames) {
            MetaDataInstanceFactory.createStepExecution(jobExecution, stepName, stepExecutionId);
            Long l = stepExecutionId;
            stepExecutionId = stepExecutionId + 1L;
        }
        return jobExecution;
    }

    public static StepExecution createStepExecution(JobParameters jobParameters, ExecutionContext executionContext) {
        StepExecution stepExecution = MetaDataInstanceFactory.createStepExecution(jobParameters);
        stepExecution.setExecutionContext(executionContext);
        return stepExecution;
    }

    public static StepExecution createStepExecution(JobParameters jobParameters) {
        Long jobExecutionId = jobExecutionIdCounter.incrementAndGet();
        Long stepExecutionId = stepExecutionIdCounter.incrementAndGet();
        JobExecution jobExecution = MetaDataInstanceFactory.createJobExecution(DEFAULT_JOB_NAME, 12L, jobExecutionId, jobParameters);
        StepExecution stepExecution = MetaDataInstanceFactory.createStepExecution(jobExecution, DEFAULT_STEP_NAME, stepExecutionId);
        jobExecution.addStepExecution(stepExecution);
        return stepExecution;
    }

    public static StepExecution createStepExecution(ExecutionContext executionContext) {
        StepExecution stepExecution = MetaDataInstanceFactory.createStepExecution();
        stepExecution.setExecutionContext(executionContext);
        return stepExecution;
    }
}

