/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.job.Job;
import org.springframework.batch.core.job.JobExecution;
import org.springframework.batch.core.job.SimpleJob;
import org.springframework.batch.core.job.UnexpectedJobExecutionException;
import org.springframework.batch.core.job.parameters.JobParameter;
import org.springframework.batch.core.job.parameters.JobParameters;
import org.springframework.batch.core.job.parameters.JobParametersInvalidException;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.listener.JobExecutionListener;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.core.step.Step;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.lang.Nullable;

@Deprecated(since="6.0", forRemoval=true)
public class StepRunner {
    public static final String JOB_NAME = "TestJob";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final JobLauncher launcher;
    private final JobRepository jobRepository;

    public StepRunner(JobLauncher launcher, JobRepository jobRepository) {
        this.launcher = launcher;
        this.jobRepository = jobRepository;
    }

    public JobExecution launchStep(Step step) {
        return this.launchStep(step, this.makeUniqueJobParameters(), null);
    }

    public JobExecution launchStep(Step step, @Nullable ExecutionContext jobExecutionContext) {
        return this.launchStep(step, this.makeUniqueJobParameters(), jobExecutionContext);
    }

    public JobExecution launchStep(Step step, JobParameters jobParameters) {
        return this.launchStep(step, jobParameters, null);
    }

    public JobExecution launchStep(Step step, JobParameters jobParameters, final @Nullable ExecutionContext jobExecutionContext) {
        SimpleJob job = new SimpleJob();
        job.setName(JOB_NAME);
        job.setJobRepository(this.jobRepository);
        ArrayList<Step> stepsToExecute = new ArrayList<Step>();
        stepsToExecute.add(step);
        job.setSteps(stepsToExecute);
        if (jobExecutionContext != null && !jobExecutionContext.isEmpty()) {
            job.setJobExecutionListeners(new JobExecutionListener[]{new JobExecutionListener(){

                public void beforeJob(JobExecution jobExecution) {
                    ExecutionContext jobContext = jobExecution.getExecutionContext();
                    for (Map.Entry entry : jobExecutionContext.entrySet()) {
                        jobContext.put((String)entry.getKey(), entry.getValue());
                    }
                }
            }});
        }
        return this.launchJob((Job)job, jobParameters);
    }

    private JobExecution launchJob(Job job, JobParameters jobParameters) {
        try {
            return this.launcher.run(job, jobParameters);
        }
        catch (JobParametersInvalidException | JobExecutionAlreadyRunningException | JobInstanceAlreadyCompleteException | JobRestartException e) {
            throw new UnexpectedJobExecutionException("Step runner encountered exception.", e);
        }
    }

    private JobParameters makeUniqueJobParameters() {
        HashMap<String, JobParameter> parameters = new HashMap<String, JobParameter>();
        parameters.put("timestamp", new JobParameter((Object)new Date().getTime(), Long.class));
        return new JobParameters(parameters);
    }
}

