/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.junit.Assert;
import org.springframework.core.io.Resource;

public abstract class AssertFile {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertFileEquals(File expected, File actual) throws Exception {
        BufferedReader expectedReader = new BufferedReader(new FileReader(expected));
        BufferedReader actualReader = new BufferedReader(new FileReader(actual));
        try {
            int lineNum = 1;
            String expectedLine = null;
            while ((expectedLine = expectedReader.readLine()) != null) {
                String actualLine = actualReader.readLine();
                Assert.assertEquals((String)("Line number " + lineNum + " does not match."), (Object)expectedLine, (Object)actualLine);
                ++lineNum;
            }
            String actualLine = actualReader.readLine();
            Assert.assertEquals((String)("More lines than expected.  There should not be a line number " + lineNum + "."), null, (Object)actualLine);
        }
        finally {
            expectedReader.close();
            actualReader.close();
        }
    }

    public static void assertFileEquals(Resource expected, Resource actual) throws Exception {
        AssertFile.assertFileEquals(expected.getFile(), actual.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertLineCount(int expectedLineCount, File file) throws Exception {
        BufferedReader expectedReader = new BufferedReader(new FileReader(file));
        try {
            int lineCount = 0;
            while (expectedReader.readLine() != null) {
                ++lineCount;
            }
            Assert.assertEquals((long)expectedLineCount, (long)lineCount);
        }
        finally {
            expectedReader.close();
        }
    }

    public static void assertLineCount(int expectedLineCount, Resource resource) throws Exception {
        AssertFile.assertLineCount(expectedLineCount, resource.getFile());
    }
}

