/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test;

import java.util.ArrayList;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;

public class ExecutionContextTestUtils {
    public static <T> T getValueFromJob(JobExecution jobExecution, String key) {
        return (T)jobExecution.getExecutionContext().get(key);
    }

    public static <T> T getValueFromStepInJob(JobExecution jobExecution, String stepName, String key) {
        StepExecution stepExecution = null;
        ArrayList<String> stepNames = new ArrayList<String>();
        for (StepExecution candidate : jobExecution.getStepExecutions()) {
            String name = candidate.getStepName();
            stepNames.add(name);
            if (!name.equals(stepName)) continue;
            stepExecution = candidate;
        }
        if (stepExecution == null) {
            throw new IllegalArgumentException("No such step in this job execution: " + stepName + " not in " + stepNames);
        }
        Object result = stepExecution.getExecutionContext().get(key);
        return (T)result;
    }

    public static <T> T getValueFromStep(StepExecution stepExecution, String key) {
        return (T)stepExecution.getExecutionContext().get(key);
    }
}

