/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.validation.valang.custom;

import java.util.Iterator;
import java.util.List;
import org.springframework.batch.sample.domain.LineItem;
import org.springmodules.validation.valang.functions.AbstractFunction;
import org.springmodules.validation.valang.functions.Function;

public class ValidateQuantitiesFunction
extends AbstractFunction {
    private static final int MAX_QUANTITY = 9999;

    public ValidateQuantitiesFunction(Function[] arguments, int line, int column) {
        super(arguments, line, column);
        this.definedExactNumberOfArguments(1);
    }

    protected Object doGetResult(Object target) throws Exception {
        List lineItems = (List)this.getArguments()[0].getResult(target);
        Iterator i = lineItems.iterator();
        while (i.hasNext()) {
            LineItem item = (LineItem)i.next();
            if (item.getQuantity() > 0 && item.getQuantity() <= 9999) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

