/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.tasklet;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.time.StopWatch;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.listener.StepExecutionListenerSupport;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.batch.sample.tasklet.SimpleSystemProcessExitCodeMapper;
import org.springframework.batch.sample.tasklet.SystemCommandException;
import org.springframework.batch.sample.tasklet.SystemProcessExitCodeMapper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class SystemCommandTasklet
extends StepExecutionListenerSupport
implements Tasklet,
InitializingBean {
    private String command;
    private String[] environmentParams = null;
    private File workingDirectory = null;
    private SystemProcessExitCodeMapper systemProcessExitCodeMapper = new SimpleSystemProcessExitCodeMapper();
    private long timeout = 0L;
    private long checkInterval = 1000L;
    private StepExecution execution = null;

    public ExitStatus execute() throws Exception {
        ExecutorThread executorThread = new ExecutorThread();
        executorThread.start();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        while (stopWatch.getTime() < this.timeout && executorThread.isAlive() && !this.execution.isTerminateOnly()) {
            Thread.sleep(this.checkInterval);
        }
        stopWatch.stop();
        if (executorThread.finishedSuccessfully) {
            return this.systemProcessExitCodeMapper.getExitStatus(executorThread.exitCode);
        }
        executorThread.interrupt();
        if (this.execution.isTerminateOnly()) {
            throw new JobInterruptedException("Job interrupted while executing system command '" + this.command + "'");
        }
        throw new SystemCommandException("Execution of system command failed (did not finish successfully within the timeout)");
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setEnvironmentParams(String[] envp) {
        this.environmentParams = envp;
    }

    public void setWorkingDirectory(String dir) {
        if (dir == null) {
            this.workingDirectory = null;
            return;
        }
        this.workingDirectory = new File(dir);
        Assert.isTrue((boolean)this.workingDirectory.exists(), (String)"working directory must exist");
        Assert.isTrue((boolean)this.workingDirectory.isDirectory(), (String)"working directory value must be a directory");
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.command, (String)"'command' property value is required");
        Assert.notNull((Object)this.systemProcessExitCodeMapper, (String)"SystemProcessExitCodeMapper must be set");
        Assert.isTrue((this.timeout > 0L ? 1 : 0) != 0, (String)"timeout value must be greater than zero");
    }

    public void setSystemProcessExitCodeMapper(SystemProcessExitCodeMapper systemProcessExitCodeMapper) {
        this.systemProcessExitCodeMapper = systemProcessExitCodeMapper;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setTerminationCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    public void beforeStep(StepExecution stepExecution) {
        this.execution = stepExecution;
    }

    private class ExecutorThread
    extends Thread {
        volatile int exitCode = -1;
        volatile boolean finishedSuccessfully = false;

        private ExecutorThread() {
        }

        public void run() {
            try {
                Process process = Runtime.getRuntime().exec(SystemCommandTasklet.this.command, SystemCommandTasklet.this.environmentParams, SystemCommandTasklet.this.workingDirectory);
                this.exitCode = process.waitFor();
                this.finishedSuccessfully = true;
            }
            catch (IOException e) {
                throw new SystemCommandException("IO error while executing system command", e);
            }
            catch (InterruptedException e) {
                throw new SystemCommandException("Interrupted while executing system command", e);
            }
        }
    }
}

