/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.quartz;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.configuration.JobFactory;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.support.ClassPathXmlApplicationContextJobFactory;
import org.springframework.batch.core.repository.DuplicateJobException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.ResourceLoader;

public class QuartzBatchLauncher {
    private static Log log = LogFactory.getLog((Class)QuartzBatchLauncher.class);
    private JobRegistry registry;
    private ResourceLoader resourceLoader;
    private ApplicationContext parentContext = null;
    static /* synthetic */ Class class$org$springframework$batch$core$Job;

    public void setRegistry(JobRegistry registry) {
        this.registry = registry;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    private void register(String[] paths) throws DuplicateJobException {
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            XmlBeanFactory beanFactory = new XmlBeanFactory(this.resourceLoader.getResource(path), (BeanFactory)this.parentContext.getAutowireCapableBeanFactory());
            String[] names = beanFactory.getBeanNamesForType(class$org$springframework$batch$core$Job == null ? QuartzBatchLauncher.class$("org.springframework.batch.core.Job") : class$org$springframework$batch$core$Job);
            for (int j = 0; j < names.length; ++j) {
                this.registry.register((JobFactory)new ClassPathXmlApplicationContextJobFactory(names[j], path, this.parentContext));
            }
        }
    }

    public static void main(String[] args) throws Exception {
        final QuartzBatchLauncher launcher = new QuartzBatchLauncher();
        new Thread(new Runnable(){

            public void run() {
                launcher.run();
            }
        }).start();
        while (launcher.parentContext == null) {
            Thread.sleep(100L);
        }
        String[] paths = new String[]{"jobs/adhocLoopJob.xml", "jobs/footballJob.xml"};
        launcher.register(paths);
        log.info((Object)"Started Quartz scheduler.");
        System.in.read();
    }

    private void run() {
        ClassPathXmlApplicationContext parent = new ClassPathXmlApplicationContext("quartz-job-launcher-context.xml");
        parent.getAutowireCapableBeanFactory().autowireBeanProperties((Object)this, 2, false);
        parent.getAutowireCapableBeanFactory().initializeBean((Object)this, "quartzLauncher");
        this.parentContext = parent;
    }
}

