/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.item.writer;

import java.math.BigDecimal;
import org.springframework.batch.item.ClearFailedException;
import org.springframework.batch.item.FlushFailedException;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.BatchSqlUpdateItemWriter;
import org.springframework.batch.sample.domain.CustomerCredit;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class BatchSqlCustomerCreditIncreaseWriter
implements ItemWriter,
InitializingBean {
    private ItemWriter delegate;
    public static final BigDecimal FIXED_AMOUNT = new BigDecimal(1000);

    public void setDelegate(ItemWriter delegate) {
        this.delegate = delegate;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((boolean)(this.delegate instanceof BatchSqlUpdateItemWriter), (String)"Delegate must be set and must be an instance of BatchSqlUpdateItemWriter");
    }

    public void write(Object data) throws Exception {
        CustomerCredit customerCredit = ((CustomerCredit)data).increaseCreditBy(FIXED_AMOUNT);
        this.delegate.write((Object)customerCredit);
    }

    public void clear() throws ClearFailedException {
        this.delegate.clear();
    }

    public void flush() throws FlushFailedException {
        this.delegate.flush();
    }
}

