/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.dao;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.batch.item.file.mapping.DefaultFieldSet;
import org.springframework.batch.item.file.mapping.FieldSet;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.batch.item.transform.ItemTransformer;
import org.springframework.batch.sample.domain.Address;
import org.springframework.batch.sample.domain.BillingInfo;
import org.springframework.batch.sample.domain.Customer;
import org.springframework.batch.sample.domain.LineItem;
import org.springframework.batch.sample.domain.Order;

public class OrderTransformer
implements ItemTransformer {
    private Map aggregators;

    public Object transform(Object data) {
        Order order = (Order)data;
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getAggregator("header").aggregate(OrderFormatterUtils.headerArgs(order)));
        result.add(this.getAggregator("customer").aggregate(OrderFormatterUtils.customerArgs(order)));
        result.add(this.getAggregator("address").aggregate(OrderFormatterUtils.billingAddressArgs(order)));
        result.add(this.getAggregator("billing").aggregate(OrderFormatterUtils.billingInfoArgs(order)));
        List items = order.getLineItems();
        for (int i = 0; i < items.size(); ++i) {
            LineItem item = (LineItem)items.get(i);
            result.add(this.getAggregator("item").aggregate(OrderFormatterUtils.lineItemArgs(item)));
        }
        result.add(this.getAggregator("footer").aggregate(OrderFormatterUtils.footerArgs(order)));
        return result;
    }

    public void setAggregators(Map aggregators) {
        this.aggregators = aggregators;
    }

    private LineAggregator getAggregator(String name) {
        return (LineAggregator)this.aggregators.get(name);
    }

    private static class OrderFormatterUtils {
        private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");

        private OrderFormatterUtils() {
        }

        static FieldSet headerArgs(Order order) {
            return new DefaultFieldSet(new String[]{"BEGIN_ORDER:", String.valueOf(order.getOrderId()), dateFormat.format(order.getOrderDate())});
        }

        static FieldSet footerArgs(Order order) {
            return new DefaultFieldSet(new String[]{"END_ORDER:", order.getTotalPrice().toString()});
        }

        static FieldSet customerArgs(Order order) {
            Customer customer = order.getCustomer();
            return new DefaultFieldSet(new String[]{"CUSTOMER:", String.valueOf(customer.getRegistrationId()), customer.getFirstName(), customer.getMiddleName(), customer.getLastName()});
        }

        static FieldSet lineItemArgs(LineItem item) {
            return new DefaultFieldSet(new String[]{"ITEM:", String.valueOf(item.getItemId()), item.getPrice().toString()});
        }

        static FieldSet billingAddressArgs(Order order) {
            Address address = order.getBillingAddress();
            return new DefaultFieldSet(new String[]{"ADDRESS:", address.getAddrLine1(), address.getCity(), address.getZipCode()});
        }

        static FieldSet billingInfoArgs(Order order) {
            BillingInfo billingInfo = order.getBilling();
            return new DefaultFieldSet(new String[]{"BILLING:", billingInfo.getPaymentId(), billingInfo.getPaymentDesc()});
        }
    }
}

