/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.launch;

import org.springframework.batch.core.job.JobExecution;
import org.springframework.batch.core.job.JobExecutionException;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.integration.launch.JobLaunchRequest;
import org.springframework.batch.integration.launch.JobLaunchingMessageHandler;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.util.Assert;

public class JobLaunchingGateway
extends AbstractReplyProducingMessageHandler {
    private final JobLaunchingMessageHandler jobLaunchingMessageHandler;

    public JobLaunchingGateway(JobOperator jobOperator) {
        Assert.notNull((Object)jobOperator, (String)"jobLauncher must not be null.");
        this.jobLaunchingMessageHandler = new JobLaunchingMessageHandler(jobOperator);
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        JobExecution jobExecution;
        Assert.notNull(requestMessage, (String)"The provided requestMessage must not be null.");
        Object payload = requestMessage.getPayload();
        Assert.isInstanceOf(JobLaunchRequest.class, (Object)payload, (String)"The payload must be of type JobLaunchRequest.");
        JobLaunchRequest jobLaunchRequest = (JobLaunchRequest)payload;
        try {
            jobExecution = this.jobLaunchingMessageHandler.launch(jobLaunchRequest);
        }
        catch (JobExecutionException e) {
            throw new MessageHandlingException(requestMessage, (Throwable)e);
        }
        return jobExecution;
    }
}

