/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.remote;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.job.JobExecution;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.AbstractStep;
import org.springframework.batch.core.step.StepExecution;
import org.springframework.batch.infrastructure.poller.DirectPoller;
import org.springframework.batch.integration.partition.StepExecutionRequest;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.messaging.MessageChannel;

public class RemoteStep
extends AbstractStep {
    private static final Log logger = LogFactory.getLog((String)RemoteStep.class.getName());
    private final String remoteStepName;
    private final MessagingTemplate messagingTemplate;
    private MessageChannel messageChannel;
    private long pollInterval = 10000L;
    private long timeout = -1L;

    public RemoteStep(String name, String remoteStepName, JobRepository jobRepository, MessagingTemplate messagingTemplate) {
        super(jobRepository);
        this.setName(name);
        this.remoteStepName = remoteStepName;
        this.messagingTemplate = messagingTemplate;
        this.messageChannel = (MessageChannel)this.messagingTemplate.getDefaultDestination();
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setPollInterval(long pollInterval) {
        this.pollInterval = pollInterval;
    }

    public void setMessageChannel(MessageChannel messageChannel) {
        this.messageChannel = messageChannel;
    }

    protected void doExecute(StepExecution stepExecution) throws Exception {
        JobExecution jobExecution = stepExecution.getJobExecution();
        StepExecution workerStepExecution = this.getJobRepository().createStepExecution(this.remoteStepName, jobExecution);
        workerStepExecution.setExecutionContext(stepExecution.getExecutionContext());
        this.getJobRepository().update(workerStepExecution);
        this.getJobRepository().updateExecutionContext(workerStepExecution);
        StepExecutionRequest stepExecutionRequest = new StepExecutionRequest(this.remoteStepName, workerStepExecution.getId());
        this.messagingTemplate.convertAndSend((Object)this.messageChannel, (Object)stepExecutionRequest);
        StepExecution updatedWorkerExecution = this.pollRemoteStep(workerStepExecution);
        stepExecution.setExecutionContext(updatedWorkerExecution.getExecutionContext());
        stepExecution.upgradeStatus(updatedWorkerExecution.getStatus());
        stepExecution.setExitStatus(updatedWorkerExecution.getExitStatus());
    }

    private StepExecution pollRemoteStep(StepExecution workerStepExecution) throws Exception {
        DirectPoller poller = new DirectPoller(this.pollInterval);
        Callable<StepExecution> callable = () -> {
            StepExecution updatedExecution = this.getJobRepository().getStepExecution(workerStepExecution.getId());
            if (updatedExecution != null && updatedExecution.getStatus().isRunning()) {
                logger.info((Object)"Waiting for remote step to finish");
                return null;
            }
            return updatedExecution;
        };
        Future executionFuture = poller.poll(callable);
        if (this.timeout >= 0L) {
            return (StepExecution)executionFuture.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        return (StepExecution)executionFuture.get();
    }
}

