/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.chunk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.listener.StepExecutionListener;
import org.springframework.batch.core.step.StepContribution;
import org.springframework.batch.core.step.StepExecution;
import org.springframework.batch.core.step.item.ChunkProcessor;
import org.springframework.batch.infrastructure.item.Chunk;
import org.springframework.batch.infrastructure.item.ItemWriter;
import org.springframework.batch.integration.chunk.ChunkProcessorChunkRequestHandler;
import org.springframework.batch.integration.chunk.ChunkRequest;
import org.springframework.batch.integration.chunk.ChunkResponse;
import org.springframework.core.task.TaskExecutor;

public class ChunkTaskExecutorItemWriter<T>
implements ItemWriter<T>,
StepExecutionListener {
    private StepExecution stepExecution;
    private int sequence;
    private final TaskExecutor taskExecutor;
    private final ChunkProcessorChunkRequestHandler<T> chunkProcessorChunkHandler = new ChunkProcessorChunkRequestHandler();
    private final Set<Future<ChunkResponse>> responses = new HashSet<Future<ChunkResponse>>();

    public ChunkTaskExecutorItemWriter(ChunkProcessor<T> chunkRequestProcessor, TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
        this.chunkProcessorChunkHandler.setChunkProcessor(chunkRequestProcessor);
    }

    public void write(Chunk<? extends T> chunk) {
        ChunkRequest<? extends T> request = new ChunkRequest<T>(++this.sequence, chunk, this.stepExecution.getJobExecutionId(), this.stepExecution.createStepContribution());
        FutureTask<ChunkResponse> chunkResponseFutureTask = new FutureTask<ChunkResponse>(() -> this.chunkProcessorChunkHandler.handle((ChunkRequest<T>)request));
        this.responses.add(chunkResponseFutureTask);
        this.taskExecutor.execute(chunkResponseFutureTask);
    }

    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        try {
            for (StepContribution contribution : this.getStepContributions()) {
                stepExecution.apply(contribution);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            return ExitStatus.FAILED.addExitDescription((Throwable)e);
        }
        return ExitStatus.COMPLETED.addExitDescription("Waited for " + this.responses.size() + " results.");
    }

    private Collection<StepContribution> getStepContributions() throws ExecutionException, InterruptedException {
        ArrayList<StepContribution> contributions = new ArrayList<StepContribution>();
        for (Future<ChunkResponse> task : this.responses) {
            contributions.add(task.get().getStepContribution());
        }
        return contributions;
    }
}

