/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.chunk;

import org.springframework.batch.core.step.item.SimpleChunkProcessor;
import org.springframework.batch.integration.chunk.ChunkProcessorChunkHandler;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.support.PassThroughItemProcessor;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class RemoteChunkingWorkerBuilder<I, O> {
    private static final String SERVICE_ACTIVATOR_METHOD_NAME = "handleChunk";
    private ItemProcessor<I, O> itemProcessor;
    private ItemWriter<O> itemWriter;
    private MessageChannel inputChannel;
    private MessageChannel outputChannel;

    public RemoteChunkingWorkerBuilder<I, O> itemProcessor(ItemProcessor<I, O> itemProcessor) {
        Assert.notNull(itemProcessor, (String)"itemProcessor must not be null");
        this.itemProcessor = itemProcessor;
        return this;
    }

    public RemoteChunkingWorkerBuilder<I, O> itemWriter(ItemWriter<O> itemWriter) {
        Assert.notNull(itemWriter, (String)"itemWriter must not be null");
        this.itemWriter = itemWriter;
        return this;
    }

    public RemoteChunkingWorkerBuilder<I, O> inputChannel(MessageChannel inputChannel) {
        Assert.notNull((Object)inputChannel, (String)"inputChannel must not be null");
        this.inputChannel = inputChannel;
        return this;
    }

    public RemoteChunkingWorkerBuilder<I, O> outputChannel(MessageChannel outputChannel) {
        Assert.notNull((Object)outputChannel, (String)"outputChannel must not be null");
        this.outputChannel = outputChannel;
        return this;
    }

    public IntegrationFlow build() {
        Assert.notNull(this.itemWriter, (String)"An ItemWriter must be provided");
        Assert.notNull((Object)this.inputChannel, (String)"An InputChannel must be provided");
        Assert.notNull((Object)this.outputChannel, (String)"An OutputChannel must be provided");
        if (this.itemProcessor == null) {
            this.itemProcessor = new PassThroughItemProcessor();
        }
        SimpleChunkProcessor chunkProcessor = new SimpleChunkProcessor(this.itemProcessor, this.itemWriter);
        ChunkProcessorChunkHandler chunkProcessorChunkHandler = new ChunkProcessorChunkHandler();
        chunkProcessorChunkHandler.setChunkProcessor(chunkProcessor);
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlow.from((MessageChannel)this.inputChannel).handle(chunkProcessorChunkHandler, SERVICE_ACTIVATOR_METHOD_NAME)).channel(this.outputChannel)).get();
    }
}

