/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.chunk;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.step.item.ChunkProcessor;
import org.springframework.batch.core.step.item.FaultTolerantChunkProcessor;
import org.springframework.batch.core.step.skip.NonSkippableReadException;
import org.springframework.batch.core.step.skip.SkipLimitExceededException;
import org.springframework.batch.core.step.skip.SkipListenerFailedException;
import org.springframework.batch.integration.chunk.ChunkHandler;
import org.springframework.batch.integration.chunk.ChunkRequest;
import org.springframework.batch.integration.chunk.ChunkResponse;
import org.springframework.batch.item.Chunk;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.retry.RetryException;
import org.springframework.util.Assert;

@MessageEndpoint
public class ChunkProcessorChunkHandler<S>
implements ChunkHandler<S>,
InitializingBean {
    private static final Log logger = LogFactory.getLog(ChunkProcessorChunkHandler.class);
    private ChunkProcessor<S> chunkProcessor;

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.chunkProcessor != null ? 1 : 0) != 0, (String)"A ChunkProcessor must be provided");
    }

    public void setChunkProcessor(ChunkProcessor<S> chunkProcessor) {
        this.chunkProcessor = chunkProcessor;
    }

    @Override
    @ServiceActivator
    public ChunkResponse handleChunk(ChunkRequest<S> chunkRequest) throws Exception {
        StepContribution stepContribution;
        Throwable failure;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Handling chunk: " + chunkRequest));
        }
        if ((failure = this.process(chunkRequest, stepContribution = chunkRequest.getStepContribution())) != null) {
            logger.debug((Object)"Failed chunk", failure);
            return new ChunkResponse(false, chunkRequest.getSequence(), chunkRequest.getJobId(), stepContribution, failure.getClass().getName() + ": " + failure.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Completed chunk handling with " + stepContribution));
        }
        return new ChunkResponse(true, chunkRequest.getSequence(), chunkRequest.getJobId(), stepContribution);
    }

    private Throwable process(ChunkRequest<S> chunkRequest, StepContribution stepContribution) throws Exception {
        Chunk<S> chunk = chunkRequest.getItems();
        Throwable failure = null;
        try {
            this.chunkProcessor.process(stepContribution, chunk);
        }
        catch (SkipLimitExceededException e) {
            failure = e;
        }
        catch (NonSkippableReadException e) {
            failure = e;
        }
        catch (SkipListenerFailedException e) {
            failure = e;
        }
        catch (RetryException e) {
            failure = e;
        }
        catch (JobInterruptedException e) {
            failure = e;
        }
        catch (Exception e) {
            if (this.chunkProcessor instanceof FaultTolerantChunkProcessor) {
                throw e;
            }
            failure = e;
        }
        return failure;
    }
}

