/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.chunk;

import java.io.Serializable;
import org.springframework.batch.core.StepContribution;

public class ChunkResponse
implements Serializable {
    private final StepContribution stepContribution;
    private final Long jobId;
    private final boolean status;
    private final String message;
    private final boolean redelivered;

    public ChunkResponse(Long jobId, StepContribution stepContribution) {
        this(true, jobId, stepContribution, null);
    }

    public ChunkResponse(boolean status, Long jobId, StepContribution stepContribution) {
        this(status, jobId, stepContribution, null);
    }

    public ChunkResponse(boolean status, Long jobId, StepContribution stepContribution, String message) {
        this(status, jobId, stepContribution, message, false);
    }

    public ChunkResponse(ChunkResponse input, boolean redelivered) {
        this(input.status, input.jobId, input.stepContribution, input.message, redelivered);
    }

    public ChunkResponse(boolean status, Long jobId, StepContribution stepContribution, String message, boolean redelivered) {
        this.status = status;
        this.jobId = jobId;
        this.stepContribution = stepContribution;
        this.message = message;
        this.redelivered = redelivered;
    }

    public StepContribution getStepContribution() {
        return this.stepContribution;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public boolean isSuccessful() {
        return this.status;
    }

    public boolean isRedelivered() {
        return this.redelivered;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": jobId=" + this.jobId + ", stepContribution=" + this.stepContribution + ", successful=" + this.status;
    }
}

