/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.chunk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.listener.StepExecutionListenerSupport;
import org.springframework.batch.integration.chunk.AsynchronousFailureException;
import org.springframework.batch.integration.chunk.ChunkRequest;
import org.springframework.batch.integration.chunk.ChunkResponse;
import org.springframework.batch.integration.chunk.StepContributionSource;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemWriter;
import org.springframework.integration.gateway.MessagingGateway;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkMessageChannelItemWriter<T>
extends StepExecutionListenerSupport
implements ItemWriter<T>,
ItemStream,
StepContributionSource {
    private static final Log logger = LogFactory.getLog(ChunkMessageChannelItemWriter.class);
    static final String ACTUAL = ChunkMessageChannelItemWriter.class.getName() + ".ACTUAL";
    static final String EXPECTED = ChunkMessageChannelItemWriter.class.getName() + ".EXPECTED";
    private static final long DEFAULT_THROTTLE_LIMIT = 6L;
    private MessagingGateway messagingGateway;
    private LocalState localState = new LocalState();
    private long throttleLimit = 6L;
    private int DEFAULT_MAX_WAIT_TIMEOUTS;
    private int maxWaitTimeouts = this.DEFAULT_MAX_WAIT_TIMEOUTS = 40;

    public void setMaxWaitTimeouts(int maxWaitTimeouts) {
        this.maxWaitTimeouts = maxWaitTimeouts;
    }

    public void setThrottleLimit(long throttleLimit) {
        this.throttleLimit = throttleLimit;
    }

    public void setMessagingGateway(MessagingGateway messagingGateway) {
        this.messagingGateway = messagingGateway;
    }

    public void write(List<? extends T> items) throws Exception {
        while ((long)this.localState.getExpecting() > this.throttleLimit) {
            this.getNextResult();
        }
        if (!items.isEmpty()) {
            logger.debug((Object)("Dispatching chunk: " + items));
            ChunkRequest<? extends T> request = new ChunkRequest<T>(items, this.localState.getJobId(), this.localState.createStepContribution());
            this.messagingGateway.send(request);
            this.localState.incrementExpected();
        }
    }

    public void beforeStep(StepExecution stepExecution) {
        this.localState.setStepExecution(stepExecution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExitStatus afterStep(StepExecution stepExecution) {
        boolean timedOut;
        if (stepExecution.getStatus() != BatchStatus.COMPLETED) {
            return ExitStatus.EXECUTING;
        }
        long expecting = this.localState.getExpecting();
        try {
            logger.debug((Object)"Waiting for results in step listener...");
            timedOut = !this.waitForResults();
            logger.debug((Object)"Finished waiting for results in step listener.");
        }
        catch (RuntimeException e) {
            logger.debug((Object)"Detected failure waiting for results in step listener.", (Throwable)e);
            stepExecution.setStatus(BatchStatus.FAILED);
            ExitStatus exitStatus = ExitStatus.FAILED.addExitDescription(e.getClass().getName() + ": " + e.getMessage());
            return exitStatus;
        }
        finally {
            for (StepContribution contribution : this.getStepContributions()) {
                stepExecution.apply(contribution);
            }
        }
        if (timedOut) {
            stepExecution.setStatus(BatchStatus.FAILED);
            throw new ItemStreamException("Timed out waiting for back log at end of step");
        }
        return ExitStatus.COMPLETED.addExitDescription("Waited for " + expecting + " results.");
    }

    public void close() throws ItemStreamException {
        this.localState.reset();
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        if (executionContext.containsKey(EXPECTED)) {
            this.localState.open(executionContext.getInt(EXPECTED), executionContext.getInt(ACTUAL));
            if (!this.waitForResults()) {
                throw new ItemStreamException("Timed out waiting for back log on open");
            }
        }
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        executionContext.putInt(EXPECTED, this.localState.expected.intValue());
        executionContext.putInt(ACTUAL, this.localState.actual.intValue());
    }

    @Override
    public Collection<StepContribution> getStepContributions() {
        return this.localState.pollStepContributions();
    }

    private boolean waitForResults() throws AsynchronousFailureException {
        int count = 0;
        int maxCount = this.maxWaitTimeouts;
        Throwable failure = null;
        logger.error((Object)("Waiting for " + this.localState.getExpecting() + " results"));
        while (this.localState.getExpecting() > 0 && count++ < maxCount) {
            try {
                this.getNextResult();
            }
            catch (Throwable t) {
                logger.error((Object)("Detected error in remote result. Trying to recover " + this.localState.getExpecting() + " outstanding results before completing."), t);
                failure = t;
            }
        }
        if (failure != null) {
            throw ChunkMessageChannelItemWriter.wrapIfNecessary(failure);
        }
        return count < maxCount;
    }

    private void getNextResult() throws AsynchronousFailureException {
        ChunkResponse payload = (ChunkResponse)this.messagingGateway.receive();
        if (payload != null) {
            Long jobInstanceId;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found result: " + payload));
            }
            Assert.state(((jobInstanceId = payload.getJobId()) != null ? 1 : 0) != 0, (String)"Message did not contain job instance id.");
            Assert.state((boolean)jobInstanceId.equals(this.localState.getJobId()), (String)("Message contained wrong job instance id [" + jobInstanceId + "] should have been [" + this.localState.getJobId() + "]."));
            if (payload.isRedelivered()) {
                logger.warn((Object)"Redelivered result detected, which may indicate stale state. In the best case, we just picked up a timed out message from a previous failed execution. In the worst case (and if this is not a restart), the step may now timeout.  In that case if you believe that all messages from workers have been sent, the business state is probably inconsistent, and the step will fail.");
                this.localState.incrementRedelivered();
            }
            this.localState.pushStepContribution(payload.getStepContribution());
            this.localState.incrementActual();
            if (!payload.isSuccessful()) {
                throw new AsynchronousFailureException("Failure or interrupt detected in handler: " + payload.getMessage());
            }
        }
    }

    private static AsynchronousFailureException wrapIfNecessary(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof AsynchronousFailureException) {
            return (AsynchronousFailureException)((Object)throwable);
        }
        return new AsynchronousFailureException("Exception in remote process", throwable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalState {
        private AtomicInteger actual = new AtomicInteger();
        private AtomicInteger expected = new AtomicInteger();
        private AtomicInteger redelivered = new AtomicInteger();
        private StepExecution stepExecution;
        private Queue<StepContribution> contributions = new LinkedBlockingQueue<StepContribution>();

        private LocalState() {
        }

        public int getExpecting() {
            return this.expected.get() - this.actual.get();
        }

        public void open(int expectedValue, int actualValue) {
            this.actual.set(actualValue);
            this.expected.set(expectedValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<StepContribution> pollStepContributions() {
            ArrayList<StepContribution> set = new ArrayList<StepContribution>();
            Queue<StepContribution> queue = this.contributions;
            synchronized (queue) {
                StepContribution item = this.contributions.poll();
                while (item != null) {
                    set.add(item);
                    item = this.contributions.poll();
                }
            }
            return set;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pushStepContribution(StepContribution stepContribution) {
            Queue<StepContribution> queue = this.contributions;
            synchronized (queue) {
                this.contributions.add(stepContribution);
            }
        }

        public void incrementRedelivered() {
            this.redelivered.incrementAndGet();
        }

        public void incrementActual() {
            this.actual.incrementAndGet();
        }

        public void incrementExpected() {
            this.expected.incrementAndGet();
        }

        public StepContribution createStepContribution() {
            return this.stepExecution.createStepContribution();
        }

        public Long getJobId() {
            return this.stepExecution.getJobExecution().getJobId();
        }

        public void setStepExecution(StepExecution stepExecution) {
            this.stepExecution = stepExecution;
        }

        public void reset() {
            this.expected.set(0);
            this.actual.set(0);
        }
    }
}

