/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.jms;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.jms.JmsException;
import org.springframework.jms.core.JmsOperations;
import org.springframework.retry.interceptor.MethodInvocationRecoverer;
import org.springframework.util.Assert;

public class JmsMethodInvocationRecoverer<T>
implements MethodInvocationRecoverer<T> {
    protected Log logger = LogFactory.getLog(this.getClass());
    private JmsOperations jmsTemplate;

    public JmsMethodInvocationRecoverer(JmsOperations jmsTemplate) {
        Assert.notNull((Object)jmsTemplate, (String)"jmsTemplate must not be null");
        this.jmsTemplate = jmsTemplate;
    }

    public void setJmsTemplate(JmsOperations jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public @Nullable T recover(Object[] items, Throwable cause) {
        try {
            for (Object item : items) {
                this.jmsTemplate.convertAndSend(item);
            }
            return null;
        }
        catch (JmsException e) {
            this.logger.error((Object)"Could not recover because of JmsException.", (Throwable)e);
            throw e;
        }
    }
}

