/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.database;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Query;
import java.util.Iterator;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.ExecutionContext;
import org.springframework.batch.infrastructure.item.ItemStreamException;
import org.springframework.batch.infrastructure.item.database.orm.JpaQueryProvider;
import org.springframework.batch.infrastructure.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JpaCursorItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements InitializingBean {
    private EntityManagerFactory entityManagerFactory;
    private @Nullable EntityManager entityManager;
    private @Nullable String queryString;
    private @Nullable JpaQueryProvider queryProvider;
    private @Nullable Map<String, Object> parameterValues;
    private @Nullable Map<String, Object> hintValues;
    private @Nullable Iterator<T> iterator;

    public JpaCursorItemReader(EntityManagerFactory entityManagerFactory) {
        Assert.notNull((Object)entityManagerFactory, (String)"EntityManagerFactory must not be null.");
        this.entityManagerFactory = entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public void setQueryProvider(JpaQueryProvider queryProvider) {
        this.queryProvider = queryProvider;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setParameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
    }

    public void setHintValues(Map<String, Object> hintValues) {
        this.hintValues = hintValues;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.queryProvider == null) {
            Assert.state((boolean)StringUtils.hasLength((String)this.queryString), (String)"Query string is required when queryProvider is null");
        }
    }

    @Override
    protected void doOpen() throws Exception {
        this.entityManager = this.entityManagerFactory.createEntityManager();
        if (this.entityManager == null) {
            throw new DataAccessResourceFailureException("Unable to create an EntityManager");
        }
        if (this.queryProvider != null) {
            this.queryProvider.setEntityManager(this.entityManager);
        }
        Query query = this.createQuery();
        if (this.parameterValues != null) {
            this.parameterValues.forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
        }
        if (this.hintValues != null) {
            this.hintValues.forEach((arg_0, arg_1) -> ((Query)query).setHint(arg_0, arg_1));
        }
        this.iterator = query.getResultStream().iterator();
    }

    private Query createQuery() {
        if (this.queryProvider == null) {
            return this.entityManager.createQuery(this.queryString);
        }
        return this.queryProvider.createQuery();
    }

    @Override
    protected @Nullable T doRead() {
        return this.iterator.hasNext() ? (T)this.iterator.next() : null;
    }

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        super.update(executionContext);
        this.entityManager.clear();
    }

    @Override
    protected void doClose() {
        this.entityManager.close();
    }
}

