/*
 * Copyright 2006-2023 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.batch.infrastructure.item;

import org.jspecify.annotations.Nullable;

/**
 * Exception representing any errors encountered while processing a stream.
 *
 * @author Dave Syer
 * @author Lucas Ward
 * @author Mahmoud Ben Hassine
 * @author Stefano Cordio
 */
public class ItemStreamException extends RuntimeException {

	/**
	 * @param message the String that contains a detailed message.
	 */
	public ItemStreamException(String message) {
		super(message);
	}

	/**
	 * Constructs a new instance with a message and nested exception.
	 * @param msg the exception message (can be {@code null}).
	 * @param nested the cause of the exception.
	 */
	public ItemStreamException(@Nullable String msg, Throwable nested) {
		super(msg, nested);
	}

	/**
	 * Constructs a new instance with a nested exception and empty message.
	 * @param nested the cause of the exception.
	 */
	public ItemStreamException(Throwable nested) {
		super(nested);
	}

}
