/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.support;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.ExecutionContext;
import org.springframework.batch.infrastructure.item.ItemReader;
import org.springframework.batch.infrastructure.item.ItemStream;
import org.springframework.batch.infrastructure.item.ItemStreamException;
import org.springframework.batch.infrastructure.item.ItemStreamReader;
import org.springframework.batch.infrastructure.item.PeekableItemReader;
import org.springframework.util.Assert;

public class SingleItemPeekableItemReader<T>
implements ItemStreamReader<T>,
PeekableItemReader<T> {
    private ItemReader<T> delegate;
    private @Nullable T next;
    private ExecutionContext executionContext = new ExecutionContext();

    public SingleItemPeekableItemReader(ItemReader<T> delegate) {
        Assert.notNull(delegate, (String)"The delegate item reader must not be null");
        this.delegate = delegate;
    }

    public void setDelegate(ItemReader<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public @Nullable T read() throws Exception {
        if (this.next != null) {
            T item = this.next;
            this.next = null;
            return item;
        }
        return this.delegate.read();
    }

    @Override
    public @Nullable T peek() throws Exception {
        if (this.next == null) {
            this.updateDelegate(this.executionContext);
            this.next = this.delegate.read();
        }
        return this.next;
    }

    @Override
    public void close() throws ItemStreamException {
        this.next = null;
        ItemReader<T> itemReader = this.delegate;
        if (itemReader instanceof ItemStream) {
            ItemStream itemStream = (ItemStream)((Object)itemReader);
            itemStream.close();
        }
        this.executionContext = new ExecutionContext();
    }

    @Override
    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.next = null;
        ItemReader<T> itemReader = this.delegate;
        if (itemReader instanceof ItemStream) {
            ItemStream itemStream = (ItemStream)((Object)itemReader);
            itemStream.open(executionContext);
        }
        this.executionContext = new ExecutionContext();
    }

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        if (this.next != null) {
            for (Map.Entry<String, Object> entry : this.executionContext.entrySet()) {
                executionContext.put(entry.getKey(), entry.getValue());
            }
            return;
        }
        this.updateDelegate(executionContext);
    }

    private void updateDelegate(ExecutionContext executionContext) {
        ItemReader<T> itemReader = this.delegate;
        if (itemReader instanceof ItemStream) {
            ItemStream itemStream = (ItemStream)((Object)itemReader);
            itemStream.update(executionContext);
        }
    }
}

