/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.redis.builder;

import org.jspecify.annotations.NonNull;
import org.springframework.batch.infrastructure.item.redis.RedisItemWriter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;

public class RedisItemWriterBuilder<K, V> {
    private RedisTemplate<K, V> redisTemplate;
    private Converter<@NonNull V, @NonNull K> itemKeyMapper;
    private boolean delete;

    public RedisItemWriterBuilder<K, V> redisTemplate(RedisTemplate<K, V> redisTemplate) {
        this.redisTemplate = redisTemplate;
        return this;
    }

    public RedisItemWriterBuilder<K, V> itemKeyMapper(Converter<@NonNull V, @NonNull K> itemKeyMapper) {
        this.itemKeyMapper = itemKeyMapper;
        return this;
    }

    public RedisItemWriterBuilder<K, V> delete(boolean delete) {
        this.delete = delete;
        return this;
    }

    public RedisItemWriter<@NonNull K, @NonNull V> build() {
        Assert.notNull(this.redisTemplate, (String)"RedisTemplate is required.");
        Assert.notNull(this.itemKeyMapper, (String)"itemKeyMapper is required.");
        RedisItemWriter<@NonNull K, @NonNull V> writer = new RedisItemWriter<K, V>(this.itemKeyMapper, this.redisTemplate);
        writer.setDelete(this.delete);
        return writer;
    }
}

