/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.infrastructure.item.Chunk;
import org.springframework.batch.infrastructure.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.Assert;

public abstract class KeyValueItemWriter<K, V>
implements ItemWriter<V>,
InitializingBean {
    private static final Log logger = LogFactory.getLog(KeyValueItemWriter.class);
    protected Converter<V, K> itemKeyMapper;
    protected boolean delete;

    public KeyValueItemWriter(Converter<V, K> itemKeyMapper) {
        Assert.notNull(itemKeyMapper, (String)"itemKeyMapper must not be null");
        this.itemKeyMapper = itemKeyMapper;
    }

    @Override
    public void write(Chunk<? extends V> chunk) throws Exception {
        for (Object item : chunk) {
            Object key = this.itemKeyMapper.convert(item);
            this.writeKeyValue(key, item);
        }
        this.flush();
    }

    protected void flush() throws Exception {
    }

    protected abstract void writeKeyValue(K var1, V var2);

    protected abstract void init();

    public void setItemKeyMapper(Converter<V, K> itemKeyMapper) {
        this.itemKeyMapper = itemKeyMapper;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }
}

