/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.adapter;

import java.lang.reflect.Method;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MethodInvoker;
import org.springframework.util.ReflectionUtils;

public class HippyMethodInvoker
extends MethodInvoker {
    protected @Nullable Method findMatchingMethod() {
        String targetMethod = this.getTargetMethod();
        @Nullable Object[] arguments = this.getArguments();
        Class targetClass = this.getTargetClass();
        Assert.state((targetClass != null ? 1 : 0) != 0, (String)"No target class set");
        Method[] candidates = ReflectionUtils.getAllDeclaredMethods((Class)targetClass);
        int minTypeDiffWeight = Integer.MAX_VALUE;
        Method matchingMethod = null;
        Object[] transformedArguments = null;
        for (Method candidate : candidates) {
            int typeDiffWeight;
            if (!candidate.getName().equals(targetMethod)) continue;
            Class[] paramTypes = candidate.getParameterTypes();
            @Nullable Object[] candidateArguments = new Object[paramTypes.length];
            int assignedParameterCount = 0;
            block1: for (Object argument : arguments) {
                for (int i = 0; i < paramTypes.length; ++i) {
                    if (!ClassUtils.isAssignableValue((Class)paramTypes[i], (Object)argument) || candidateArguments[i] != null) continue;
                    candidateArguments[i] = argument;
                    ++assignedParameterCount;
                    continue block1;
                }
            }
            if (paramTypes.length != assignedParameterCount || (typeDiffWeight = HippyMethodInvoker.getTypeDifferenceWeight((Class[])paramTypes, (Object[])candidateArguments)) >= minTypeDiffWeight) continue;
            minTypeDiffWeight = typeDiffWeight;
            matchingMethod = candidate;
            transformedArguments = candidateArguments;
        }
        if (transformedArguments == null) {
            throw new IllegalArgumentException("No matching arguments found for method: " + targetMethod);
        }
        this.setArguments(transformedArguments);
        return matchingMethod;
    }
}

