/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.file;

import org.springframework.batch.infrastructure.item.Chunk;
import org.springframework.batch.infrastructure.item.file.transform.LineAggregator;
import org.springframework.batch.infrastructure.item.support.AbstractFileItemWriter;
import org.springframework.core.io.WritableResource;
import org.springframework.util.Assert;

public class FlatFileItemWriter<T>
extends AbstractFileItemWriter<T> {
    protected LineAggregator<T> lineAggregator;

    public FlatFileItemWriter(LineAggregator<T> lineAggregator) {
        Assert.notNull(lineAggregator, (String)"LineAggregator must not be null");
        this.lineAggregator = lineAggregator;
    }

    public FlatFileItemWriter(WritableResource resource, LineAggregator<T> lineAggregator) {
        Assert.notNull((Object)resource, (String)"Resource must not be null");
        Assert.notNull(lineAggregator, (String)"LineAggregator must not be null");
        this.resource = resource;
        this.lineAggregator = lineAggregator;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.append) {
            this.shouldDeleteIfExists = false;
        }
    }

    public void setLineAggregator(LineAggregator<T> lineAggregator) {
        this.lineAggregator = lineAggregator;
    }

    @Override
    public String doWrite(Chunk<? extends T> items) {
        StringBuilder lines = new StringBuilder();
        for (Object item : items) {
            lines.append(this.lineAggregator.aggregate(item)).append(this.lineSeparator);
        }
        return lines.toString();
    }
}

