/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import java.util.Collection;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.batch.item.file.transform.PassThroughLineAggregator;
import org.springframework.util.Assert;

public class RecursiveCollectionLineAggregator<T>
implements LineAggregator<Collection<T>> {
    private String lineSeparator = System.lineSeparator();
    private LineAggregator<T> delegate = new PassThroughLineAggregator();

    public void setDelegate(LineAggregator<T> delegate) {
        this.delegate = delegate;
    }

    public void setLineSeparator(String lineSeparator) {
        Assert.notNull((Object)lineSeparator, (String)"The line separator must not be null");
        this.lineSeparator = lineSeparator;
    }

    @Override
    public String aggregate(Collection<T> items) {
        StringBuilder builder = new StringBuilder();
        for (T value : items) {
            builder.append(this.delegate.aggregate(value)).append(this.lineSeparator);
        }
        return builder.delete(builder.length() - this.lineSeparator.length(), builder.length()).toString();
    }
}

