/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.util.HashMap;
import java.util.List;

public abstract class JdbcParameterUtils {
    private JdbcParameterUtils() {
    }

    public static int countParameterPlaceholders(String sql, List<String> namedParameterHolder) {
        if (sql == null) {
            return 0;
        }
        boolean withinQuotes = false;
        HashMap<String, StringBuilder> namedParameters = new HashMap<String, StringBuilder>();
        int currentQuote = 45;
        int parameterCount = 0;
        for (int i = 0; i < sql.length(); ++i) {
            if (withinQuotes) {
                if (sql.charAt(i) != currentQuote) continue;
                withinQuotes = false;
                currentQuote = 45;
                continue;
            }
            if (sql.charAt(i) == '\"' || sql.charAt(i) == '\'') {
                withinQuotes = true;
                currentQuote = sql.charAt(i);
                continue;
            }
            if (sql.charAt(i) == ':' || sql.charAt(i) == '&') {
                int j;
                StringBuilder parameter = new StringBuilder();
                for (j = i + 1; j < sql.length() && JdbcParameterUtils.parameterNameContinues(sql, j); ++j) {
                    parameter.append(sql.charAt(j));
                }
                if (j - i <= 1 || namedParameters.containsKey(parameter.toString())) continue;
                ++parameterCount;
                namedParameters.put(parameter.toString(), parameter);
                i = j - 1;
                continue;
            }
            if (sql.charAt(i) != '?') continue;
            ++parameterCount;
        }
        if (namedParameterHolder != null) {
            namedParameterHolder.addAll(namedParameters.keySet());
        }
        return parameterCount;
    }

    private static boolean parameterNameContinues(String statement, int pos) {
        char character = statement.charAt(pos);
        return character != ' ' && character != ',' && character != ')' && character != '\"' && character != '\'' && character != '|' && character != ';' && character != '\n' && character != '\r';
    }
}

