/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import javax.sql.DataSource;
import org.springframework.batch.item.database.support.SqlWindowingPagingQueryProvider;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.jdbc.support.JdbcUtils;

public class DerbyPagingQueryProvider
extends SqlWindowingPagingQueryProvider {
    private static final String MINIMAL_DERBY_VERSION = "10.4.1.3";

    @Override
    public void init(DataSource dataSource) throws Exception {
        super.init(dataSource);
        String version = JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, (String)"getDatabaseProductVersion").toString();
        if (!this.isDerbyVersionSupported(version)) {
            throw new InvalidDataAccessResourceUsageException("Apache Derby version " + version + " is not supported by this class,  Only version " + MINIMAL_DERBY_VERSION + " or later is supported");
        }
    }

    private boolean isDerbyVersionSupported(String version) {
        String[] minimalVersionParts = MINIMAL_DERBY_VERSION.split("\\.");
        String[] versionParts = version.split("[\\. ]");
        for (int i = 0; i < minimalVersionParts.length; ++i) {
            int minimalVersionPart = Integer.valueOf(minimalVersionParts[i]);
            int versionPart = Integer.valueOf(versionParts[i]);
            if (versionPart < minimalVersionPart) {
                return false;
            }
            if (versionPart <= minimalVersionPart) continue;
            return true;
        }
        return true;
    }

    @Override
    protected String getOrderedQueryAlias() {
        return "TMP_ORDERED";
    }

    @Override
    protected String getOverClause() {
        return "";
    }

    @Override
    protected String getOverSubstituteClauseStart() {
        return " FROM (SELECT " + this.getSelectClause();
    }

    @Override
    protected String getOverSubstituteClauseEnd() {
        return " ) AS " + this.getOrderedQueryAlias();
    }
}

