/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.support;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import org.springframework.batch.repeat.support.AbstractResultQueue;
import org.springframework.batch.repeat.support.RepeatInternalState;
import org.springframework.batch.repeat.support.ResultHolder;

class JdkConcurrentResultQueue
extends AbstractResultQueue
implements RepeatInternalState {
    private final BlockingQueue results = new LinkedBlockingQueue();
    private final Semaphore waits;

    JdkConcurrentResultQueue(int throttleLimit) {
        this.waits = new Semaphore(throttleLimit);
    }

    protected void addResult(ResultHolder resultHolder) {
        this.results.add(resultHolder);
    }

    protected void aquireWait() throws InterruptedException {
        this.waits.acquire();
    }

    protected void releaseWait() {
        this.waits.release();
    }

    protected ResultHolder takeResult() throws InterruptedException {
        return (ResultHolder)this.results.take();
    }

    public boolean isEmpty() {
        return this.results.isEmpty();
    }
}

