/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.validator;

import java.util.Collection;
import java.util.Iterator;
import org.springframework.batch.item.validator.ValidationException;
import org.springframework.batch.item.validator.Validator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;

public class SpringValidator
implements Validator,
InitializingBean {
    private org.springframework.validation.Validator validator;

    public void validate(Object item) throws ValidationException {
        if (!this.validator.supports(item.getClass())) {
            throw new ValidationException("Validation failed for " + item + ": " + item.getClass().getName() + " class is not supported by validator.");
        }
        BeanPropertyBindingResult errors = new BeanPropertyBindingResult(item, "item");
        this.validator.validate(item, (Errors)errors);
        if (errors.hasErrors()) {
            throw new ValidationException("Validation failed for " + item + ": " + this.errorsToString((Errors)errors));
        }
    }

    private String errorsToString(Errors errors) {
        StringBuffer builder = new StringBuffer();
        this.appendCollection(errors.getFieldErrors(), builder);
        this.appendCollection(errors.getGlobalErrors(), builder);
        return builder.toString();
    }

    private void appendCollection(Collection collection, StringBuffer builder) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            builder.append("\n");
            builder.append(iterator.next().toString());
        }
    }

    public void setValidator(org.springframework.validation.Validator validator) {
        this.validator = validator;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.validator, (String)"validator must be set");
    }
}

