/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web.freemarker;

import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.IOException;
import org.springframework.core.io.Resource;
import org.springframework.ui.freemarker.SpringTemplateLoader;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

public class HippyFreeMarkerConfigurer
extends FreeMarkerConfigurer {
    protected TemplateLoader getTemplateLoaderForPath(String templateLoaderPath) {
        if (this.isPreferFileSystemAccess() || templateLoaderPath.startsWith("/WEB-INF")) {
            try {
                Resource path = this.getResourceLoader().getResource(templateLoaderPath);
                File file = path.getFile();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Template loader path [" + path + "] resolved to file path [" + file.getAbsolutePath() + "]"));
                }
                return new FileTemplateLoader(file);
            }
            catch (IOException ex) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Cannot resolve template loader path [" + templateLoaderPath + "] to [java.io.File]: using SpringTemplateLoader as fallback"));
                }
                return new SpringTemplateLoader(this.getResourceLoader(), templateLoaderPath);
            }
        }
        this.logger.debug((Object)"File system access not preferred: using SpringTemplateLoader");
        return new SpringTemplateLoader(this.getResourceLoader(), templateLoaderPath);
    }
}

