/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.service;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.batch.admin.service.SearchableJobExecutionDao;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.repository.dao.JdbcJobExecutionDao;
import org.springframework.batch.item.database.Order;
import org.springframework.batch.item.database.PagingQueryProvider;
import org.springframework.batch.item.database.support.SqlPagingQueryProviderFactoryBean;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.incrementer.AbstractDataFieldMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.util.Assert;

public class JdbcSearchableJobExecutionDao
extends JdbcJobExecutionDao
implements SearchableJobExecutionDao {
    private static final String GET_COUNT = "SELECT COUNT(1) from %PREFIX%JOB_EXECUTION";
    private static final String GET_COUNT_BY_JOB_NAME = "SELECT COUNT(1) from %PREFIX%JOB_EXECUTION E, %PREFIX%JOB_INSTANCE I where E.JOB_INSTANCE_ID=I.JOB_INSTANCE_ID and I.JOB_NAME=?";
    private static final String FIELDS = "E.JOB_EXECUTION_ID, E.START_TIME, E.END_TIME, E.STATUS, E.EXIT_CODE, E.EXIT_MESSAGE, E.CREATE_TIME, E.LAST_UPDATED, E.VERSION, I.JOB_INSTANCE_ID, I.JOB_NAME";
    private static final String GET_RUNNING_EXECUTIONS = "SELECT E.JOB_EXECUTION_ID, E.START_TIME, E.END_TIME, E.STATUS, E.EXIT_CODE, E.EXIT_MESSAGE, E.CREATE_TIME, E.LAST_UPDATED, E.VERSION, I.JOB_INSTANCE_ID, I.JOB_NAME from %PREFIX%JOB_EXECUTION E, %PREFIX%JOB_INSTANCE I where E.JOB_INSTANCE_ID=I.JOB_INSTANCE_ID and E.END_TIME is NULL";
    private PagingQueryProvider allExecutionsPagingQueryProvider;
    private PagingQueryProvider byJobNamePagingQueryProvider;
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.dataSource != null ? 1 : 0) != 0, (String)"DataSource must be provided");
        if (this.getJdbcTemplate() == null) {
            this.setJdbcTemplate((JdbcOperations)new JdbcTemplate(this.dataSource));
        }
        this.setJobExecutionIncrementer((DataFieldMaxValueIncrementer)new AbstractDataFieldMaxValueIncrementer(){

            protected long getNextKey() {
                return 0L;
            }
        });
        this.allExecutionsPagingQueryProvider = this.getPagingQueryProvider();
        this.byJobNamePagingQueryProvider = this.getPagingQueryProvider("I.JOB_NAME=?");
        super.afterPropertiesSet();
    }

    private PagingQueryProvider getPagingQueryProvider() throws Exception {
        return this.getPagingQueryProvider(null);
    }

    private PagingQueryProvider getPagingQueryProvider(String whereClause) throws Exception {
        return this.getPagingQueryProvider(null, whereClause);
    }

    private PagingQueryProvider getPagingQueryProvider(String fromClause, String whereClause) throws Exception {
        SqlPagingQueryProviderFactoryBean factory = new SqlPagingQueryProviderFactoryBean();
        factory.setDataSource(this.dataSource);
        fromClause = "%PREFIX%JOB_EXECUTION E, %PREFIX%JOB_INSTANCE I" + (fromClause == null ? "" : ", " + fromClause);
        factory.setFromClause(this.getQuery(fromClause));
        factory.setSelectClause(FIELDS);
        HashMap<String, Order> sortKeys = new HashMap<String, Order>();
        sortKeys.put("JOB_EXECUTION_ID", Order.DESCENDING);
        factory.setSortKeys(sortKeys);
        whereClause = "E.JOB_INSTANCE_ID=I.JOB_INSTANCE_ID" + (whereClause == null ? "" : " and " + whereClause);
        factory.setWhereClause(whereClause);
        return (PagingQueryProvider)factory.getObject();
    }

    @Override
    public int countJobExecutions() {
        return (Integer)this.getJdbcTemplate().queryForObject(this.getQuery(GET_COUNT), Integer.class);
    }

    @Override
    public int countJobExecutions(String jobName) {
        return (Integer)this.getJdbcTemplate().queryForObject(this.getQuery(GET_COUNT_BY_JOB_NAME), Integer.class, new Object[]{jobName});
    }

    @Override
    public Collection<JobExecution> getRunningJobExecutions() {
        return this.getJdbcTemplate().query(this.getQuery(GET_RUNNING_EXECUTIONS), (RowMapper)new JobExecutionRowMapper());
    }

    @Override
    public List<JobExecution> getJobExecutions(String jobName, int start, int count) {
        if (start <= 0) {
            return this.getJdbcTemplate().query(this.byJobNamePagingQueryProvider.generateFirstPageQuery(count), (RowMapper)new JobExecutionRowMapper(), new Object[]{jobName});
        }
        try {
            Long startAfterValue = (Long)this.getJdbcTemplate().queryForObject(this.byJobNamePagingQueryProvider.generateJumpToItemQuery(start, count), Long.class, new Object[]{jobName});
            return this.getJdbcTemplate().query(this.byJobNamePagingQueryProvider.generateRemainingPagesQuery(count), (RowMapper)new JobExecutionRowMapper(), new Object[]{jobName, startAfterValue});
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public List<JobExecution> getJobExecutions(int start, int count) {
        if (start <= 0) {
            return this.getJdbcTemplate().query(this.allExecutionsPagingQueryProvider.generateFirstPageQuery(count), (RowMapper)new JobExecutionRowMapper());
        }
        try {
            Long startAfterValue = (Long)this.getJdbcTemplate().queryForObject(this.allExecutionsPagingQueryProvider.generateJumpToItemQuery(start, count), Long.class);
            return this.getJdbcTemplate().query(this.allExecutionsPagingQueryProvider.generateRemainingPagesQuery(count), (RowMapper)new JobExecutionRowMapper(), new Object[]{startAfterValue});
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return Collections.emptyList();
        }
    }

    public void saveJobExecution(JobExecution jobExecution) {
        throw new UnsupportedOperationException("SearchableJobExecutionDao is read only");
    }

    public void synchronizeStatus(JobExecution jobExecution) {
        throw new UnsupportedOperationException("SearchableJobExecutionDao is read only");
    }

    public void updateJobExecution(JobExecution jobExecution) {
        throw new UnsupportedOperationException("SearchableJobExecutionDao is read only");
    }

    protected class JobExecutionRowMapper
    implements RowMapper<JobExecution> {
        public JobExecution mapRow(ResultSet rs, int rowNum) throws SQLException {
            Long id = rs.getLong(1);
            JobParameters jobParameters = JdbcSearchableJobExecutionDao.this.getJobParameters(id);
            JobInstance jobInstance = new JobInstance(Long.valueOf(rs.getLong(10)), rs.getString(11));
            JobExecution jobExecution = new JobExecution(jobInstance, jobParameters);
            jobExecution.setId(id);
            jobExecution.setStartTime((Date)rs.getTimestamp(2));
            jobExecution.setEndTime((Date)rs.getTimestamp(3));
            jobExecution.setStatus(BatchStatus.valueOf((String)rs.getString(4)));
            jobExecution.setExitStatus(new ExitStatus(rs.getString(5), rs.getString(6)));
            jobExecution.setCreateTime((Date)rs.getTimestamp(7));
            jobExecution.setLastUpdated((Date)rs.getTimestamp(8));
            jobExecution.setVersion(Integer.valueOf(rs.getInt(9)));
            return jobExecution;
        }
    }
}

