/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web;

import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import org.springframework.batch.admin.history.StepExecutionHistory;
import org.springframework.batch.admin.service.JobService;
import org.springframework.batch.admin.service.NoSuchStepExecutionException;
import org.springframework.batch.admin.web.JobExecutionInfo;
import org.springframework.batch.admin.web.StepExecutionInfo;
import org.springframework.batch.admin.web.StepExecutionProgress;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.launch.NoSuchJobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class StepExecutionController {
    private JobService jobService;
    private TimeZone timeZone = TimeZone.getDefault();

    @Autowired(required=false)
    @Qualifier(value="userTimeZone")
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Autowired
    public StepExecutionController(JobService jobService) {
        this.jobService = jobService;
    }

    @RequestMapping(value={"/jobs/executions/{jobExecutionId}/steps"}, method={RequestMethod.GET})
    public String list(Model model, @PathVariable Long jobExecutionId, @ModelAttribute(value="date") Date date, Errors errors) {
        ArrayList<StepExecutionInfo> result = new ArrayList<StepExecutionInfo>();
        try {
            for (StepExecution stepExecution : this.jobService.getStepExecutions(jobExecutionId)) {
                result.add(new StepExecutionInfo(stepExecution, TimeZone.getTimeZone("GMT")));
            }
            JobExecution jobExecution = this.jobService.getJobExecution(jobExecutionId);
            model.addAttribute((Object)new JobExecutionInfo(jobExecution, this.timeZone));
        }
        catch (NoSuchJobExecutionException e) {
            errors.reject("no.such.job.execution", new Object[]{jobExecutionId}, "There is no such job execution (" + jobExecutionId + ")");
        }
        model.addAttribute("stepExecutions", result);
        return "jobs/executions/steps";
    }

    @RequestMapping(value={"/jobs/executions/{jobExecutionId}/steps/{stepExecutionId}"}, method={RequestMethod.GET})
    public String detail(Model model, @PathVariable Long jobExecutionId, @PathVariable Long stepExecutionId, @ModelAttribute(value="date") Date date, Errors errors) {
        try {
            StepExecution stepExecution = this.jobService.getStepExecution(jobExecutionId, stepExecutionId);
            model.addAttribute((Object)new StepExecutionInfo(stepExecution, TimeZone.getTimeZone("GMT")));
        }
        catch (NoSuchStepExecutionException e) {
            errors.reject("no.such.step.execution", new Object[]{stepExecutionId}, "There is no such step execution (" + stepExecutionId + ")");
        }
        catch (NoSuchJobExecutionException e) {
            errors.reject("no.such.job.execution", new Object[]{jobExecutionId}, "There is no such job execution (" + jobExecutionId + ")");
        }
        return "jobs/executions/step";
    }

    @RequestMapping(value={"/jobs/executions/{jobExecutionId}/steps/{stepExecutionId}/progress"}, method={RequestMethod.GET})
    public String history(Model model, @PathVariable Long jobExecutionId, @PathVariable Long stepExecutionId, @ModelAttribute(value="date") Date date, Errors errors) {
        try {
            StepExecution stepExecution = this.jobService.getStepExecution(jobExecutionId, stepExecutionId);
            model.addAttribute((Object)new StepExecutionInfo(stepExecution, TimeZone.getTimeZone("GMT")));
            String stepName = stepExecution.getStepName();
            if (stepName.contains(":partition")) {
                stepName = stepName.replaceAll("(:partition).*", "$1*");
            }
            String jobName = stepExecution.getJobExecution().getJobInstance().getJobName();
            StepExecutionHistory stepExecutionHistory = this.computeHistory(jobName, stepName);
            model.addAttribute((Object)stepExecutionHistory);
            model.addAttribute((Object)new StepExecutionProgress(stepExecution, stepExecutionHistory));
        }
        catch (NoSuchStepExecutionException e) {
            errors.reject("no.such.step.execution", new Object[]{stepExecutionId}, "There is no such step execution (" + stepExecutionId + ")");
        }
        catch (NoSuchJobExecutionException e) {
            errors.reject("no.such.job.execution", new Object[]{jobExecutionId}, "There is no such job execution (" + jobExecutionId + ")");
        }
        return "jobs/executions/step/progress";
    }

    private StepExecutionHistory computeHistory(String jobName, String stepName) {
        int total = this.jobService.countStepExecutionsForStep(jobName, stepName);
        StepExecutionHistory stepExecutionHistory = new StepExecutionHistory(stepName);
        for (int i = 0; i < total; i += 1000) {
            for (StepExecution stepExecution : this.jobService.listStepExecutionsForStep(jobName, stepName, i, 1000)) {
                stepExecutionHistory.append(stepExecution);
            }
        }
        return stepExecutionHistory;
    }
}

