/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.support.PropertiesConverter;

public class JobExecutionInfo {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private SimpleDateFormat durationFormat = new SimpleDateFormat("HH:mm:ss");
    private Long id;
    private int stepExecutionCount;
    private Long jobId;
    private String jobName;
    private String startDate = "";
    private String startTime = "";
    private String duration = "";
    private JobExecution jobExecution;
    private String jobParameters;
    private boolean restartable = false;
    private boolean abandonable = false;
    private boolean stoppable = false;
    private JobParametersConverter converter = new DefaultJobParametersConverter();
    private final TimeZone timeZone;

    public JobExecutionInfo(JobExecution jobExecution, TimeZone timeZone) {
        this.jobExecution = jobExecution;
        this.timeZone = timeZone;
        this.id = jobExecution.getId();
        this.jobId = jobExecution.getJobId();
        this.stepExecutionCount = jobExecution.getStepExecutions().size();
        JobInstance jobInstance = jobExecution.getJobInstance();
        if (jobInstance != null) {
            this.jobName = jobInstance.getJobName();
            Properties properties = this.converter.getProperties(jobInstance.getJobParameters());
            this.jobParameters = PropertiesConverter.propertiesToString((Properties)properties);
            BatchStatus status = jobExecution.getStatus();
            this.restartable = status.isGreaterThan(BatchStatus.STOPPING) && status.isLessThan(BatchStatus.ABANDONED);
            this.abandonable = status.isGreaterThan(BatchStatus.STARTED) && status != BatchStatus.ABANDONED;
            this.stoppable = status.isLessThan(BatchStatus.STOPPING);
        } else {
            this.jobName = "?";
            this.jobParameters = null;
        }
        this.durationFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.timeFormat.setTimeZone(timeZone);
        this.dateFormat.setTimeZone(timeZone);
        if (jobExecution.getStartTime() != null) {
            this.startDate = this.dateFormat.format(jobExecution.getStartTime());
            this.startTime = this.timeFormat.format(jobExecution.getStartTime());
            Date endTime = jobExecution.getEndTime() != null ? jobExecution.getEndTime() : new Date();
            this.duration = this.durationFormat.format(new Date(endTime.getTime() - jobExecution.getStartTime().getTime()));
        }
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String getName() {
        return this.jobName;
    }

    public Long getId() {
        return this.id;
    }

    public int getStepExecutionCount() {
        return this.stepExecutionCount;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getDuration() {
        return this.duration;
    }

    public JobExecution getJobExecution() {
        return this.jobExecution;
    }

    public boolean isRestartable() {
        return this.restartable;
    }

    public boolean isAbandonable() {
        return this.abandonable;
    }

    public boolean isStoppable() {
        return this.stoppable;
    }

    public String getJobParameters() {
        return this.jobParameters;
    }
}

