/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.integration;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.configuration.DuplicateJobException;
import org.springframework.batch.core.configuration.support.ApplicationContextFactory;
import org.springframework.batch.core.configuration.support.ClassPathXmlApplicationContextFactory;
import org.springframework.batch.core.configuration.support.JobLoader;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;

@MessageEndpoint
public class JobConfigurationResourceLoader
implements ApplicationContextAware {
    private JobLoader jobLoader;
    private ApplicationContext parent;

    public void setJobLoader(JobLoader jobLoader) {
        this.jobLoader = jobLoader;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parent = applicationContext;
    }

    @ServiceActivator
    public String loadJobs(Resource resource) throws DuplicateJobException {
        ArrayList<String> result = new ArrayList<String>();
        ApplicationContextFactory factory = this.createApplicationContextFactory(this.parent, resource);
        Collection jobs = this.jobLoader.reload(factory);
        for (Job job : jobs) {
            result.add(job.getName());
        }
        return "Registered jobs: " + result;
    }

    protected ApplicationContextFactory createApplicationContextFactory(ApplicationContext parent, Resource resource) {
        ClassPathXmlApplicationContextFactory applicationContextFactory = new ClassPathXmlApplicationContextFactory();
        applicationContextFactory.setResource(resource);
        if (parent != null) {
            applicationContextFactory.setApplicationContext(parent);
        }
        return applicationContextFactory;
    }
}

