/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.FileCopyUtils;

public class ResourceHttpMessageConverter
extends AbstractHttpMessageConverter<Resource> {
    public ResourceHttpMessageConverter() {
        super(MediaType.ALL);
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return Resource.class.isAssignableFrom(clazz);
    }

    @Override
    protected Resource readInternal(Class<? extends Resource> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        byte[] body = FileCopyUtils.copyToByteArray((InputStream)inputMessage.getBody());
        return new ByteArrayResource(body);
    }

    @Override
    protected MediaType getDefaultContentType(Resource resource) {
        return MediaType.APPLICATION_OCTET_STREAM;
    }

    @Override
    protected Long getContentLength(Resource resource, MediaType contentType) throws IOException {
        return resource.contentLength();
    }

    @Override
    protected void writeInternal(Resource resource, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        FileCopyUtils.copy((InputStream)resource.getInputStream(), (OutputStream)outputMessage.getBody());
        outputMessage.getBody().flush();
    }
}

