/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.analytics.rest.controller;

import java.util.ArrayList;
import java.util.List;
import org.springframework.analytics.rest.domain.CounterResource;
import org.springframework.analytics.rest.domain.MetricResource;
import org.springframework.boot.actuate.endpoint.mvc.MetricsMvcEndpoint;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.repository.MetricRepository;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/metrics/counters"})
@ExposesResourceFor(value=CounterResource.class)
public class CounterController {
    public static final String COUNTER_PREFIX = "counter.";
    private final MetricRepository metricRepository;
    private final ResourceAssembler<Metric<Double>, CounterResource> counterResourceAssembler = new DeepCounterResourceAssembler();
    protected final ResourceAssembler<Metric<Double>, ? extends MetricResource> shallowResourceAssembler = new ShallowMetricResourceAssembler();

    public CounterController(MetricRepository metricRepository) {
        Assert.notNull((Object)metricRepository, (String)"metricRepository must not be null");
        this.metricRepository = metricRepository;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public PagedResources<? extends MetricResource> list(Pageable pageable, PagedResourcesAssembler<Metric<Double>> pagedAssembler, @RequestParam(value="detailed", defaultValue="false") boolean detailed) {
        Iterable metrics = this.metricRepository.findAll();
        List content = this.filterCounters(metrics);
        long count = content.size();
        long pageEnd = Math.min(count, (long)(pageable.getOffset() + pageable.getPageSize()));
        PageImpl counterPage = new PageImpl(content.subList(pageable.getOffset(), (int)pageEnd), pageable, (long)content.size());
        Object assemblerToUse = detailed ? this.counterResourceAssembler : this.shallowResourceAssembler;
        return pagedAssembler.toResource((Page)counterPage, assemblerToUse);
    }

    @RequestMapping(value={"/{name}"}, method={RequestMethod.GET})
    public CounterResource display(@PathVariable(value="name") String name) {
        Metric<Double> c = this.findCounter(name);
        return (CounterResource)this.counterResourceAssembler.toResource(c);
    }

    @RequestMapping(value={"/{name}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    protected void delete(@PathVariable(value="name") String name) {
        Metric<Double> c = this.findCounter(name);
        this.metricRepository.reset(c.getName());
    }

    private Metric<Double> findCounter(@PathVariable(value="name") String name) {
        Metric c = this.metricRepository.findOne(COUNTER_PREFIX + name);
        if (c == null) {
            throw new MetricsMvcEndpoint.NoSuchMetricException(name);
        }
        return c;
    }

    private <T extends Number> List<Metric<T>> filterCounters(Iterable<Metric<?>> input) {
        ArrayList<Metric<T>> result = new ArrayList<Metric<T>>();
        for (Metric<?> metric : input) {
            if (!metric.getName().startsWith(COUNTER_PREFIX)) continue;
            result.add(metric);
        }
        return result;
    }

    static class DeepCounterResourceAssembler
    extends ResourceAssemblerSupport<Metric<Double>, CounterResource> {
        public DeepCounterResourceAssembler() {
            super(CounterController.class, CounterResource.class);
        }

        public CounterResource toResource(Metric<Double> entity) {
            return (CounterResource)this.createResourceWithId(entity.getName().substring(CounterController.COUNTER_PREFIX.length()), entity);
        }

        protected CounterResource instantiateResource(Metric<Double> entity) {
            return new CounterResource(entity.getName().substring(CounterController.COUNTER_PREFIX.length()), ((Double)entity.getValue()).longValue());
        }
    }

    static class ShallowMetricResourceAssembler
    extends ResourceAssemblerSupport<Metric<Double>, MetricResource> {
        public ShallowMetricResourceAssembler() {
            super(CounterController.class, MetricResource.class);
        }

        public MetricResource toResource(Metric<Double> entity) {
            return (MetricResource)this.createResourceWithId(entity.getName().substring(CounterController.COUNTER_PREFIX.length()), entity);
        }

        protected MetricResource instantiateResource(Metric<Double> entity) {
            return new MetricResource(entity.getName().substring(CounterController.COUNTER_PREFIX.length()));
        }
    }
}

