/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.analytics.metrics.redis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Months;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.Years;
import org.springframework.analytics.metrics.AggregateCounter;
import org.springframework.analytics.metrics.AggregateCounterRepository;
import org.springframework.analytics.metrics.AggregateCounterResolution;
import org.springframework.analytics.metrics.MetricUtils;
import org.springframework.analytics.metrics.redis.AggregateKeyGenerator;
import org.springframework.analytics.retry.RedisRetryTemplate;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.serializer.GenericToStringSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.retry.RetryOperations;
import org.springframework.util.Assert;

public class RedisAggregateCounterRepository
implements AggregateCounterRepository {
    private static final String AGGREGATE_COUNTER_KEY_PREFIX = "aggregate-counters";
    private final RedisRetryTemplate redisTemplate = new RedisRetryTemplate();
    protected HashOperations<String, String, Long> hashOperations;
    protected SetOperations<String, String> setOperations;

    public RedisAggregateCounterRepository(RedisConnectionFactory redisConnectionFactory, RetryOperations retryOperations) {
        this.redisTemplate.setConnectionFactory(redisConnectionFactory);
        this.redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        this.redisTemplate.setValueSerializer((RedisSerializer)new StringRedisSerializer());
        this.redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        this.redisTemplate.setHashValueSerializer((RedisSerializer)new GenericToStringSerializer(Long.class));
        this.redisTemplate.setRetryOperations(retryOperations);
        this.redisTemplate.afterPropertiesSet();
        this.hashOperations = this.redisTemplate.opsForHash();
        this.setOperations = this.redisTemplate.opsForSet();
    }

    long increment(String name) {
        return this.increment(name, 1L, new DateTime());
    }

    @Override
    public long increment(String name, long amount, DateTime dateTime) {
        AggregateKeyGenerator akg = new AggregateKeyGenerator(AGGREGATE_COUNTER_KEY_PREFIX, name, (ReadableDateTime)dateTime);
        String bookkeepingKey = this.bookkeepingKeyFor(name);
        if (!this.setOperations.isMember((Object)AGGREGATE_COUNTER_KEY_PREFIX, (Object)name).booleanValue()) {
            this.setOperations.add((Object)AGGREGATE_COUNTER_KEY_PREFIX, (Object[])new String[]{name});
        }
        this.doIncrementHash(akg.getYearsKey(), akg.getYear(), amount, bookkeepingKey);
        this.doIncrementHash(akg.getYearKey(), akg.getMonth(), amount, bookkeepingKey);
        this.doIncrementHash(akg.getMonthKey(), akg.getDay(), amount, bookkeepingKey);
        this.doIncrementHash(akg.getDayKey(), akg.getHour(), amount, bookkeepingKey);
        this.doIncrementHash(akg.getHourKey(), akg.getMinute(), amount, bookkeepingKey);
        return this.redisTemplate.boundValueOps(this.getMetricKey(name)).increment(amount);
    }

    protected String getMetricKey(String metricName) {
        return "aggregate-counters." + metricName;
    }

    private String bookkeepingKeyFor(String counterName) {
        return "metric_meta.aggregatecounters." + counterName;
    }

    private void doIncrementHash(String key, String hashKey, long amount, String bookkeepingKey) {
        long newValue = this.hashOperations.increment((Object)key, (Object)hashKey, amount);
        if (newValue == amount) {
            this.setOperations.add((Object)bookkeepingKey, (Object[])new String[]{key});
        }
    }

    @Override
    public AggregateCounter getCounts(String name, int nCounts, AggregateCounterResolution resolution) {
        return this.getCounts(name, nCounts, new DateTime(), resolution);
    }

    @Override
    public AggregateCounter getCounts(String name, int nCounts, DateTime endDate, AggregateCounterResolution resolution) {
        Assert.notNull((Object)endDate, (String)"endDate cannot be null");
        return this.getCounts(name, new Interval((ReadableInstant)resolution.minus(endDate, nCounts - 1), (ReadableInstant)endDate), resolution);
    }

    @Override
    public AggregateCounter getCounts(String name, Interval interval, AggregateCounterResolution resolution) {
        long[] counts;
        DateTime end = interval.getEnd();
        Chronology c = interval.getChronology();
        if (resolution == AggregateCounterResolution.minute) {
            MutableDateTime dt = new MutableDateTime((Object)interval.getStart());
            dt.setRounding(c.hourOfDay());
            Duration step = Duration.standardHours((long)1L);
            ArrayList<long[]> hours = new ArrayList<long[]>();
            while (dt.isBefore((ReadableInstant)end) || dt.isEqual((ReadableInstant)end)) {
                hours.add(this.getMinCountsForHour(name, (ReadableDateTime)dt));
                dt.add((ReadableDuration)step);
            }
            counts = MetricUtils.concatArrays(hours, interval.getStart().getMinuteOfHour(), interval.toPeriod().toStandardMinutes().getMinutes() + 1);
        } else if (resolution == AggregateCounterResolution.hour) {
            DateTime cursor = new DateTime(c.dayOfMonth().roundFloor(interval.getStart().getMillis()));
            ArrayList<long[]> days = new ArrayList<long[]>();
            Duration step = Duration.standardHours((long)24L);
            while (cursor.isBefore((ReadableInstant)end)) {
                days.add(this.getHourCountsForDay(name, cursor));
                cursor = cursor.plus((ReadableDuration)step);
            }
            counts = MetricUtils.concatArrays(days, interval.getStart().getHourOfDay(), interval.toPeriod().toStandardHours().getHours() + 1);
        } else if (resolution == AggregateCounterResolution.day) {
            DateTime startDay = new DateTime(c.dayOfYear().roundFloor(interval.getStart().getMillis()));
            DateTime endDay = new DateTime(c.dayOfYear().roundFloor(end.plusDays(1).getMillis()));
            int nDays = Days.daysBetween((ReadableInstant)startDay, (ReadableInstant)endDay).getDays();
            DateTime cursor = new DateTime(c.monthOfYear().roundFloor(interval.getStart().getMillis()));
            ArrayList<long[]> months = new ArrayList<long[]>();
            DateTime endMonth = new DateTime(c.monthOfYear().roundCeiling(interval.getEnd().plusMonths(1).getMillis()));
            while (cursor.isBefore((ReadableInstant)endMonth)) {
                months.add(this.getDayCountsForMonth(name, cursor));
                cursor = cursor.plusMonths(1);
            }
            counts = MetricUtils.concatArrays(months, interval.getStart().getDayOfMonth() - 1, nDays);
        } else if (resolution == AggregateCounterResolution.month) {
            DateTime startMonth = new DateTime(c.monthOfYear().roundFloor(interval.getStartMillis()));
            DateTime endMonth = new DateTime(c.monthOfYear().roundFloor(end.plusMonths(1).getMillis()));
            int nMonths = Months.monthsBetween((ReadableInstant)startMonth, (ReadableInstant)endMonth).getMonths();
            DateTime cursor = new DateTime(c.year().roundFloor(interval.getStartMillis()));
            ArrayList<long[]> years = new ArrayList<long[]>();
            DateTime endYear = new DateTime(c.year().roundCeiling(interval.getEnd().plusYears(1).getMillis()));
            while (cursor.isBefore((ReadableInstant)endYear)) {
                years.add(this.getMonthCountsForYear(name, cursor));
                cursor = cursor.plusYears(1);
            }
            counts = MetricUtils.concatArrays(years, interval.getStart().getMonthOfYear() - 1, nMonths);
        } else if (resolution == AggregateCounterResolution.year) {
            DateTime startYear = new DateTime(interval.getStart().getYear(), 1, 1, 0, 0);
            DateTime endYear = new DateTime(end.getYear() + 1, 1, 1, 0, 0);
            int nYears = Years.yearsBetween((ReadableInstant)startYear, (ReadableInstant)endYear).getYears();
            Map<String, Long> yearCounts = this.getYearCounts(name);
            counts = new long[nYears];
            for (int i = 0; i < nYears; ++i) {
                int year = startYear.plusYears(i).getYear();
                Long count = yearCounts.get(Integer.toString(year));
                if (count == null) {
                    count = 0L;
                }
                counts[i] = count;
            }
        } else {
            throw new IllegalStateException("Shouldn't happen. Unhandled resolution: " + (Object)((Object)resolution));
        }
        return new AggregateCounter(name, interval, counts, resolution);
    }

    @Override
    public List<String> list() {
        Set aggregateCounters = this.setOperations.members((Object)AGGREGATE_COUNTER_KEY_PREFIX);
        ArrayList<String> list = new ArrayList<String>();
        if (aggregateCounters != null && !aggregateCounters.isEmpty()) {
            list.addAll(aggregateCounters);
            Collections.sort(list);
        }
        return list;
    }

    @Override
    public AggregateCounter findOne(String name) {
        return this.getCounts(name, 1000, new DateTime(), AggregateCounterResolution.minute);
    }

    private Map<String, Long> getYearCounts(String name) {
        AggregateKeyGenerator akg = new AggregateKeyGenerator(AGGREGATE_COUNTER_KEY_PREFIX, name, (ReadableDateTime)new DateTime());
        return this.getEntries(akg.getYearsKey());
    }

    private long[] getMonthCountsForYear(String name, DateTime year) {
        AggregateKeyGenerator akg = new AggregateKeyGenerator(AGGREGATE_COUNTER_KEY_PREFIX, name, (ReadableDateTime)year);
        return this.convertToArray(this.getEntries(akg.getYearKey()), year.monthOfYear().getMaximumValue(), true);
    }

    private long[] getDayCountsForMonth(String name, DateTime month) {
        AggregateKeyGenerator akg = new AggregateKeyGenerator(AGGREGATE_COUNTER_KEY_PREFIX, name, (ReadableDateTime)month.withTimeAtStartOfDay());
        return this.convertToArray(this.getEntries(akg.getMonthKey()), month.dayOfMonth().getMaximumValue(), true);
    }

    private long[] getHourCountsForDay(String name, DateTime day) {
        AggregateKeyGenerator akg = new AggregateKeyGenerator(AGGREGATE_COUNTER_KEY_PREFIX, name, (ReadableDateTime)day.withTimeAtStartOfDay());
        return this.convertToArray(this.getEntries(akg.getDayKey()), 24, false);
    }

    private long[] getMinCountsForHour(String name, ReadableDateTime dateTime) {
        return this.getMinCountsForHour(name, dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth(), dateTime.getHourOfDay());
    }

    private long[] getMinCountsForHour(String name, int year, int month, int day, int hour) {
        DateTime dt = new DateTime().withYear(year).withMonthOfYear(month).withDayOfMonth(day).withHourOfDay(hour);
        AggregateKeyGenerator akg = new AggregateKeyGenerator(AGGREGATE_COUNTER_KEY_PREFIX, name, (ReadableDateTime)dt);
        return this.convertToArray(this.getEntries(akg.getHourKey()), 60, false);
    }

    private Map<String, Long> getEntries(String key) {
        return this.hashOperations.entries((Object)key);
    }

    private long[] convertToArray(Map<String, Long> map, int size, boolean unitOffset) {
        long[] values = new long[size];
        int arrayOffset = unitOffset ? -1 : 0;
        for (Map.Entry<String, Long> cursor : map.entrySet()) {
            int offset = Integer.parseInt(cursor.getKey()) + arrayOffset;
            values[offset] = cursor.getValue();
        }
        return values;
    }

    @Override
    public void reset(String id) {
        this.redisTemplate.delete(this.getMetricKey(id));
        String metricMetaKey = this.bookkeepingKeyFor(id);
        Set otherKeys = this.setOperations.members((Object)metricMetaKey);
        otherKeys.add(metricMetaKey);
        this.redisTemplate.delete(otherKeys);
        Set members = this.setOperations.members((Object)AGGREGATE_COUNTER_KEY_PREFIX);
        if (members.contains(id)) {
            this.setOperations.remove((Object)AGGREGATE_COUNTER_KEY_PREFIX, new Object[]{id});
        }
    }
}

