/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.analytics.metrics;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.Assert;

public final class FieldValueCounter {
    private final String name;
    private final Map<String, Double> fieldValueCounts;

    public FieldValueCounter(String name) {
        Assert.notNull((Object)name);
        this.name = name;
        this.fieldValueCounts = new ConcurrentHashMap<String, Double>();
    }

    public FieldValueCounter(String name, Map<String, Double> fieldValueCounts) {
        Assert.notNull((Object)name);
        Assert.notNull(fieldValueCounts);
        this.name = name;
        this.fieldValueCounts = fieldValueCounts;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Double> getFieldValueCounts() {
        return this.fieldValueCounts;
    }

    public String toString() {
        return "FieldValueCounter [name=" + this.name + ", fieldValueCounts=" + this.fieldValueCounts + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldValueCounter)) {
            return false;
        }
        FieldValueCounter other = (FieldValueCounter)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

