/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import org.jspecify.annotations.Nullable;
import org.springframework.amqp.rabbit.config.AbstractRetryOperationsInterceptorFactoryBean;
import org.springframework.amqp.rabbit.config.StatefulRetryOperationsInterceptor;
import org.springframework.amqp.rabbit.retry.MessageKeyGenerator;
import org.springframework.amqp.rabbit.retry.NewMessageIdentifier;

public class StatefulRetryOperationsInterceptorFactoryBean
extends AbstractRetryOperationsInterceptorFactoryBean {
    private @Nullable MessageKeyGenerator messageKeyGenerator;
    private @Nullable NewMessageIdentifier newMessageIdentifier;

    public void setMessageKeyGenerator(MessageKeyGenerator messageKeyGenerator) {
        this.messageKeyGenerator = messageKeyGenerator;
    }

    public void setNewMessageIdentifier(NewMessageIdentifier newMessageIdentifier) {
        this.newMessageIdentifier = newMessageIdentifier;
    }

    public StatefulRetryOperationsInterceptor getObject() {
        return new StatefulRetryOperationsInterceptor(this.getMessageKeyGenerator(), this.getNewMessageIdentifier(), this.getRetryPolicy(), this.getMessageRecoverer());
    }

    private NewMessageIdentifier getNewMessageIdentifier() {
        if (this.newMessageIdentifier != null) {
            return this.newMessageIdentifier;
        }
        return message -> Boolean.FALSE.equals(message.getMessageProperties().isRedelivered());
    }

    private MessageKeyGenerator getMessageKeyGenerator() {
        if (this.messageKeyGenerator != null) {
            return this.messageKeyGenerator;
        }
        return message -> {
            String messageId = message.getMessageProperties().getMessageId();
            if (messageId == null && Boolean.TRUE.equals(message.getMessageProperties().isRedelivered())) {
                message.getMessageProperties().setFinalRetryForMessageWithNoId(true);
            }
            return messageId;
        };
    }

    public Class<?> getObjectType() {
        return StatefulRetryOperationsInterceptor.class;
    }
}

