/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.support.micrometer;

import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.docs.ObservationDocumentation;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.support.micrometer.RabbitListenerObservationConvention;
import org.springframework.amqp.rabbit.support.micrometer.RabbitMessageReceiverContext;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum RabbitListenerObservation implements ObservationDocumentation
{
    LISTENER_OBSERVATION{

        public Class<? extends ObservationConvention<? extends Observation.Context>> getDefaultConvention() {
            return DefaultRabbitListenerObservationConvention.class;
        }

        public KeyName[] getLowCardinalityKeyNames() {
            return ListenerLowCardinalityTags.values();
        }

        public KeyName[] getHighCardinalityKeyNames() {
            return ListenerHighCardinalityTags.values();
        }
    };


    public static class DefaultRabbitListenerObservationConvention
    implements RabbitListenerObservationConvention {
        public static final DefaultRabbitListenerObservationConvention INSTANCE = new DefaultRabbitListenerObservationConvention();

        public KeyValues getLowCardinalityKeyValues(RabbitMessageReceiverContext context) {
            MessageProperties messageProperties = ((Message)context.getCarrier()).getMessageProperties();
            return KeyValues.of((String[])new String[]{ListenerLowCardinalityTags.LISTENER_ID.asString(), context.getListenerId(), ListenerLowCardinalityTags.DESTINATION_NAME.asString(), messageProperties.getConsumerQueue()});
        }

        public KeyValues getHighCardinalityKeyValues(RabbitMessageReceiverContext context) {
            return KeyValues.of((String)ListenerHighCardinalityTags.DELIVERY_TAG.asString(), (String)String.valueOf(((Message)context.getCarrier()).getMessageProperties().getDeliveryTag()));
        }

        public String getContextualName(RabbitMessageReceiverContext context) {
            return context.getSource() + " receive";
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ListenerHighCardinalityTags implements KeyName
    {
        DELIVERY_TAG{

            public String asString() {
                return "messaging.rabbitmq.message.delivery_tag";
            }
        };

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ListenerLowCardinalityTags implements KeyName
    {
        LISTENER_ID{

            public String asString() {
                return "spring.rabbit.listener.id";
            }
        }
        ,
        DESTINATION_NAME{

            public String asString() {
                return "messaging.destination.name";
            }
        };

    }
}

