/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener.adapter;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.rabbit.listener.adapter.AbstractAdaptableMessageListener;
import org.springframework.amqp.rabbit.listener.adapter.DelegatingInvocableHandler;
import org.springframework.amqp.rabbit.listener.adapter.InvocationResult;
import org.springframework.amqp.rabbit.listener.adapter.MonoHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;

public class HandlerAdapter {
    private final @Nullable InvocableHandlerMethod invokerHandlerMethod;
    private final @Nullable DelegatingInvocableHandler delegatingHandler;
    private final boolean asyncReplies;

    public HandlerAdapter(InvocableHandlerMethod invokerHandlerMethod) {
        this.invokerHandlerMethod = invokerHandlerMethod;
        this.delegatingHandler = null;
        this.asyncReplies = AbstractAdaptableMessageListener.monoPresent && MonoHandler.isMono(invokerHandlerMethod.getMethod().getReturnType()) || CompletableFuture.class.isAssignableFrom(invokerHandlerMethod.getMethod().getReturnType());
    }

    public HandlerAdapter(DelegatingInvocableHandler delegatingHandler) {
        this.invokerHandlerMethod = null;
        this.delegatingHandler = delegatingHandler;
        this.asyncReplies = delegatingHandler.isAsyncReplies();
    }

    public InvocationResult invoke(Message<?> message, Object ... providedArgs) throws Exception {
        InvocableHandlerMethod invokerHandlerMethodToUse = this.invokerHandlerMethod;
        if (invokerHandlerMethodToUse != null) {
            return new InvocationResult(invokerHandlerMethodToUse.invoke(message, providedArgs), null, invokerHandlerMethodToUse.getMethod().getGenericReturnType(), invokerHandlerMethodToUse.getBean(), invokerHandlerMethodToUse.getMethod());
        }
        Assert.notNull((Object)this.delegatingHandler, (String)"'delegatingHandler' or 'invokerHandlerMethod' is required");
        if (this.delegatingHandler.hasDefaultHandler()) {
            Object[] args = new Object[providedArgs.length + 1];
            args[0] = message.getPayload();
            System.arraycopy(providedArgs, 0, args, 1, providedArgs.length);
            return this.delegatingHandler.invoke(message, args);
        }
        return this.delegatingHandler.invoke(message, providedArgs);
    }

    public String getMethodAsString(Object payload) {
        if (this.invokerHandlerMethod != null) {
            return this.invokerHandlerMethod.getMethod().toGenericString();
        }
        Assert.notNull((Object)this.delegatingHandler, (String)"'delegatingHandler' or 'invokerHandlerMethod' is required");
        return this.delegatingHandler.getMethodNameFor(payload);
    }

    public Method getMethodFor(Object payload) {
        if (this.invokerHandlerMethod != null) {
            return this.invokerHandlerMethod.getMethod();
        }
        Assert.notNull((Object)this.delegatingHandler, (String)"'delegatingHandler' or 'invokerHandlerMethod' is required");
        return this.delegatingHandler.getMethodFor(payload);
    }

    public Type getReturnTypeFor(Object payload) {
        if (this.invokerHandlerMethod != null) {
            return this.invokerHandlerMethod.getMethod().getReturnType();
        }
        Assert.notNull((Object)this.delegatingHandler, (String)"'delegatingHandler' or 'invokerHandlerMethod' is required");
        return this.delegatingHandler.getMethodFor(payload).getReturnType();
    }

    public Object getBean() {
        if (this.invokerHandlerMethod != null) {
            return this.invokerHandlerMethod.getBean();
        }
        Assert.notNull((Object)this.delegatingHandler, (String)"'delegatingHandler' or 'invokerHandlerMethod' is required");
        return this.delegatingHandler.getBean();
    }

    public boolean isAsyncReplies() {
        return this.asyncReplies;
    }

    public @Nullable InvocationResult getInvocationResultFor(Object result, Object inboundPayload) {
        if (this.invokerHandlerMethod != null) {
            return new InvocationResult(result, null, this.invokerHandlerMethod.getMethod().getGenericReturnType(), this.invokerHandlerMethod.getBean(), this.invokerHandlerMethod.getMethod());
        }
        Assert.notNull((Object)this.delegatingHandler, (String)"'delegatingHandler' or 'invokerHandlerMethod' is required");
        return this.delegatingHandler.getInvocationResultFor(result, inboundPayload);
    }
}

