/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.support.micrometer;

import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.docs.ObservationDocumentation;
import org.springframework.amqp.rabbit.support.micrometer.RabbitMessageSenderContext;
import org.springframework.amqp.rabbit.support.micrometer.RabbitTemplateObservationConvention;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum RabbitTemplateObservation implements ObservationDocumentation
{
    TEMPLATE_OBSERVATION{

        public Class<? extends ObservationConvention<? extends Observation.Context>> getDefaultConvention() {
            return DefaultRabbitTemplateObservationConvention.class;
        }

        public KeyName[] getLowCardinalityKeyNames() {
            return TemplateLowCardinalityTags.values();
        }
    };


    public static class DefaultRabbitTemplateObservationConvention
    implements RabbitTemplateObservationConvention {
        public static final DefaultRabbitTemplateObservationConvention INSTANCE = new DefaultRabbitTemplateObservationConvention();

        public KeyValues getLowCardinalityKeyValues(RabbitMessageSenderContext context) {
            return KeyValues.of((String[])new String[]{TemplateLowCardinalityTags.BEAN_NAME.asString(), context.getBeanName(), TemplateLowCardinalityTags.EXCHANGE.asString(), context.getExchange(), TemplateLowCardinalityTags.ROUTING_KEY.asString(), context.getRoutingKey()});
        }

        public String getContextualName(RabbitMessageSenderContext context) {
            return context.getDestination() + " send";
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TemplateLowCardinalityTags implements KeyName
    {
        BEAN_NAME{

            public String asString() {
                return "spring.rabbit.template.name";
            }
        }
        ,
        EXCHANGE{

            public String asString() {
                return "messaging.destination.name";
            }
        }
        ,
        ROUTING_KEY{

            public String asString() {
                return "messaging.rabbitmq.destination.routing_key";
            }
        };

    }
}

