/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.support;

import com.rabbitmq.client.PossibleAuthenticationFailureException;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.util.concurrent.TimeoutException;
import org.springframework.amqp.AmqpAuthenticationException;
import org.springframework.amqp.AmqpConnectException;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.AmqpTimeoutException;
import org.springframework.amqp.AmqpUnsupportedEncodingException;
import org.springframework.amqp.UncategorizedAmqpException;
import org.springframework.amqp.rabbit.support.ConsumerCancelledException;
import org.springframework.util.Assert;

public final class RabbitExceptionTranslator {
    private RabbitExceptionTranslator() {
    }

    public static RuntimeException convertRabbitAccessException(Throwable ex) {
        Assert.notNull((Object)ex, (String)"Exception must not be null");
        if (ex instanceof AmqpException) {
            AmqpException amqpException = (AmqpException)ex;
            return amqpException;
        }
        if (ex instanceof ShutdownSignalException) {
            ShutdownSignalException sigEx = (ShutdownSignalException)ex;
            return new AmqpConnectException((Exception)sigEx);
        }
        if (ex instanceof ConnectException) {
            ConnectException connEx = (ConnectException)ex;
            return new AmqpConnectException((Exception)connEx);
        }
        if (ex instanceof PossibleAuthenticationFailureException) {
            return new AmqpAuthenticationException(ex);
        }
        if (ex instanceof UnsupportedEncodingException) {
            return new AmqpUnsupportedEncodingException(ex);
        }
        if (ex instanceof IOException) {
            IOException ioEx = (IOException)ex;
            return new AmqpIOException(ioEx);
        }
        if (ex instanceof TimeoutException) {
            return new AmqpTimeoutException(ex);
        }
        if (ex instanceof com.rabbitmq.client.ConsumerCancelledException) {
            return new ConsumerCancelledException(ex);
        }
        if (ex instanceof ConsumerCancelledException) {
            ConsumerCancelledException consumerCancelledException = (ConsumerCancelledException)ex;
            return consumerCancelledException;
        }
        return new UncategorizedAmqpException(ex);
    }
}

