/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.log4j;

import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.HeadersExchange;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.DeclareExchangeConnectionListener;
import org.springframework.amqp.rabbit.support.LogAppenderUtils;

public class AmqpAppender
extends AppenderSkeleton {
    public static final String APPLICATION_ID = "applicationId";
    public static final String CATEGORY_NAME = "categoryName";
    public static final String CATEGORY_LEVEL = "level";
    private String exchangeName = "logs";
    private String exchangeType = "topic";
    private String routingKeyPattern = "%c.%p";
    private Layout routingKeyLayout;
    private final Object layoutMutex = new Object();
    private String applicationId = null;
    private final LinkedBlockingQueue<Event> events = new LinkedBlockingQueue();
    private ExecutorService senderPool = null;
    private int senderPoolSize = 2;
    private int maxSenderRetries = 30;
    private final Timer retryTimer = new Timer("log-event-retry-delay", true);
    private AbstractConnectionFactory connectionFactory;
    private String clientConnectionProperties;
    private String addresses;
    private String host = "localhost";
    private String virtualHost = "/";
    private int port = 5672;
    private String username = "guest";
    private String password = "guest";
    private String contentType = "text/plain";
    private String contentEncoding = null;
    private boolean declareExchange = false;
    private String charset;
    private boolean durable = true;
    private MessageDeliveryMode deliveryMode = MessageDeliveryMode.PERSISTENT;
    private boolean autoDelete = false;
    private boolean generateId = false;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAddresses(String addresses) {
        this.addresses = addresses;
    }

    public String getAddresses() {
        return this.addresses;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public void setExchangeName(String exchangeName) {
        this.exchangeName = exchangeName;
    }

    public String getExchangeType() {
        return this.exchangeType;
    }

    public void setExchangeType(String exchangeType) {
        this.exchangeType = exchangeType;
    }

    public String getRoutingKeyPattern() {
        return this.routingKeyPattern;
    }

    public void setRoutingKeyPattern(String routingKeyPattern) {
        this.routingKeyPattern = routingKeyPattern;
    }

    public boolean isDeclareExchange() {
        return this.declareExchange;
    }

    public void setDeclareExchange(boolean declareExchange) {
        this.declareExchange = declareExchange;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public int getSenderPoolSize() {
        return this.senderPoolSize;
    }

    public void setSenderPoolSize(int senderPoolSize) {
        this.senderPoolSize = senderPoolSize;
    }

    public int getMaxSenderRetries() {
        return this.maxSenderRetries;
    }

    public void setMaxSenderRetries(int maxSenderRetries) {
        this.maxSenderRetries = maxSenderRetries;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public String getDeliveryMode() {
        return this.deliveryMode.toString();
    }

    public void setDeliveryMode(String deliveryMode) {
        this.deliveryMode = MessageDeliveryMode.valueOf((String)deliveryMode);
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    public void setAutoDelete(boolean autoDelete) {
        this.autoDelete = autoDelete;
    }

    public boolean isGenerateId() {
        return this.generateId;
    }

    public void setGenerateId(boolean generateId) {
        this.generateId = generateId;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setClientConnectionProperties(String clientConnectionProperties) {
        this.clientConnectionProperties = clientConnectionProperties;
    }

    public void activateOptions() {
        this.routingKeyLayout = new PatternLayout(this.routingKeyPattern.replaceAll("%X\\{applicationId\\}", this.applicationId));
        this.connectionFactory = new CachingConnectionFactory();
        this.connectionFactory.setHost(this.host);
        this.connectionFactory.setPort(this.port);
        if (this.addresses != null) {
            this.connectionFactory.setAddresses(this.addresses);
        }
        this.connectionFactory.setUsername(this.username);
        this.connectionFactory.setPassword(this.password);
        this.connectionFactory.setVirtualHost(this.virtualHost);
        LogAppenderUtils.updateClientConnectionProperties(this.connectionFactory, this.clientConnectionProperties);
        this.updateConnectionClientProperties(this.connectionFactory.getRabbitConnectionFactory().getClientProperties());
        this.setUpExchangeDeclaration();
        this.startSenders();
    }

    protected void updateConnectionClientProperties(Map<String, Object> clientProperties) {
    }

    @Deprecated
    protected void maybeDeclareExchange() {
        this.setUpExchangeDeclaration();
    }

    protected void setUpExchangeDeclaration() {
        RabbitAdmin admin = new RabbitAdmin(this.connectionFactory);
        if (this.declareExchange) {
            Object x = "topic".equals(this.exchangeType) ? new TopicExchange(this.exchangeName, this.durable, this.autoDelete) : ("direct".equals(this.exchangeType) ? new DirectExchange(this.exchangeName, this.durable, this.autoDelete) : ("fanout".equals(this.exchangeType) ? new FanoutExchange(this.exchangeName, this.durable, this.autoDelete) : ("headers".equals(this.exchangeType) ? new HeadersExchange(this.exchangeType, this.durable, this.autoDelete) : new TopicExchange(this.exchangeName, this.durable, this.autoDelete))));
            this.connectionFactory.addConnectionListener(new DeclareExchangeConnectionListener((Exchange)x, admin));
        }
    }

    protected void startSenders() {
        this.senderPool = Executors.newCachedThreadPool();
        for (int i = 0; i < this.senderPoolSize; ++i) {
            this.senderPool.submit(new EventSender());
        }
    }

    public void append(LoggingEvent event) {
        this.events.add(new Event(event, event.getProperties()));
    }

    public void close() {
        if (null != this.senderPool) {
            this.senderPool.shutdownNow();
            this.senderPool = null;
        }
        if (null != this.connectionFactory) {
            this.connectionFactory.destroy();
        }
        this.retryTimer.cancel();
    }

    public boolean requiresLayout() {
        return true;
    }

    public Message postProcessMessageBeforeSend(Message message, Event event) {
        return message;
    }

    protected static class Event {
        final LoggingEvent event;
        final Map properties;
        final AtomicInteger retries = new AtomicInteger(0);

        public Event(LoggingEvent event, Map properties) {
            this.event = event;
            this.properties = properties;
        }

        public LoggingEvent getEvent() {
            return this.event;
        }

        public Map getProperties() {
            return this.properties;
        }

        public int incrementRetries() {
            return this.retries.incrementAndGet();
        }
    }

    protected class EventSender
    implements Runnable {
        protected EventSender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                RabbitTemplate rabbitTemplate = new RabbitTemplate(AmqpAppender.this.connectionFactory);
                while (true) {
                    String routingKey;
                    StringBuilder msgBody;
                    final Event event = (Event)AmqpAppender.this.events.take();
                    LoggingEvent logEvent = event.getEvent();
                    String name = logEvent.getLogger().getName();
                    Level level = logEvent.getLevel();
                    MessageProperties amqpProps = new MessageProperties();
                    amqpProps.setDeliveryMode(AmqpAppender.this.deliveryMode);
                    amqpProps.setContentType(AmqpAppender.this.contentType);
                    if (null != AmqpAppender.this.contentEncoding) {
                        amqpProps.setContentEncoding(AmqpAppender.this.contentEncoding);
                    }
                    amqpProps.setHeader(AmqpAppender.CATEGORY_NAME, (Object)name);
                    amqpProps.setHeader(AmqpAppender.CATEGORY_LEVEL, (Object)level.toString());
                    if (AmqpAppender.this.generateId) {
                        amqpProps.setMessageId(UUID.randomUUID().toString());
                    }
                    if (null != AmqpAppender.this.applicationId) {
                        amqpProps.setAppId(AmqpAppender.this.applicationId);
                    }
                    Calendar tstamp = Calendar.getInstance();
                    tstamp.setTimeInMillis(logEvent.getTimeStamp());
                    amqpProps.setTimestamp(tstamp.getTime());
                    Map props = event.getProperties();
                    Set entrySet = props.entrySet();
                    for (Map.Entry entry : entrySet) {
                        amqpProps.setHeader(entry.getKey().toString(), entry.getValue());
                    }
                    LocationInfo locInfo = logEvent.getLocationInformation();
                    if (!"?".equals(locInfo.getClassName())) {
                        amqpProps.setHeader("location", (Object)String.format("%s.%s()[%s]", locInfo.getClassName(), locInfo.getMethodName(), locInfo.getLineNumber()));
                    }
                    Object object = AmqpAppender.this.layoutMutex;
                    synchronized (object) {
                        msgBody = new StringBuilder(AmqpAppender.this.layout.format(logEvent));
                        routingKey = AmqpAppender.this.routingKeyLayout.format(logEvent);
                    }
                    if (AmqpAppender.this.layout.ignoresThrowable() && null != logEvent.getThrowableInformation()) {
                        ThrowableInformation tinfo = logEvent.getThrowableInformation();
                        for (String line : tinfo.getThrowableStrRep()) {
                            msgBody.append(String.format("%s%n", line));
                        }
                    }
                    try {
                        Message message = null;
                        if (AmqpAppender.this.charset != null) {
                            try {
                                message = new Message(msgBody.toString().getBytes(AmqpAppender.this.charset), amqpProps);
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                // empty catch block
                            }
                        }
                        if (message == null) {
                            message = new Message(msgBody.toString().getBytes(), amqpProps);
                        }
                        message = AmqpAppender.this.postProcessMessageBeforeSend(message, event);
                        rabbitTemplate.send(AmqpAppender.this.exchangeName, routingKey, message);
                    }
                    catch (AmqpException e) {
                        int retries = event.incrementRetries();
                        if (retries < AmqpAppender.this.maxSenderRetries) {
                            AmqpAppender.this.retryTimer.schedule(new TimerTask(){

                                @Override
                                public void run() {
                                    AmqpAppender.this.events.add(event);
                                }
                            }, (long)(Math.pow(retries, Math.log(retries)) * 1000.0));
                            continue;
                        }
                        AmqpAppender.this.errorHandler.error("Could not send log message " + logEvent.getRenderedMessage() + " after " + AmqpAppender.this.maxSenderRetries + " retries", (Exception)((Object)e), 1, logEvent);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }
}

